/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.chancesd.pvpmanager.manager.DeathHandler;
import me.chancesd.pvpmanager.manager.PlayerManager;
import me.chancesd.pvpmanager.player.CombatPlayer;
import me.chancesd.pvpmanager.player.ProtectionResult;
import me.chancesd.pvpmanager.player.UntagReason;
import me.chancesd.pvpmanager.player.world.CombatWorld;
import me.chancesd.pvpmanager.sdutils.scheduler.ScheduleUtils;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.sdutils.utils.TimeUtil;
import me.chancesd.pvpmanager.setting.Conf;
import me.chancesd.pvpmanager.setting.Lang;
import me.chancesd.pvpmanager.setting.Permissions;
import me.chancesd.pvpmanager.utils.CombatUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class PlayerListener
implements Listener {
    private final PlayerManager playerManager;
    private final DeathHandler deathHandler;
    private final Cache<UUID, String> msgCooldown = CacheBuilder.newBuilder().weakValues().expireAfterWrite(800L, TimeUnit.MILLISECONDS).build();

    public PlayerListener(PlayerManager pM) {
        this.playerManager = pM;
        this.deathHandler = new DeathHandler(pM);
    }

    @EventHandler(ignoreCancelled=true)
    public final void onPlayerEat(PlayerItemConsumeEvent event) {
        Material type = event.getItem().getType();
        CombatPlayer player = this.playerManager.get(event.getPlayer());
        if (Conf.BLOCK_EAT.asBool() && player.isInCombat() && type.isEdible()) {
            event.setCancelled(true);
            player.message(Lang.EAT_BLOCKED_IN_COMBAT, new Object[0]);
        }
        if (Conf.ITEM_COOLDOWNS.asMap().containsKey(type)) {
            if (player.hasItemCooldown(type)) {
                event.setCancelled(true);
                player.message(Lang.ITEM_COOLDOWN, TimeUtil.getDiffUntil(Lang.ITEM_COOLDOWN, (long)player.getItemCooldown(type)));
                return;
            }
            player.setItemCooldown(type, Conf.ITEM_COOLDOWNS.asMap().get(type));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public final void onPlayerKick(PlayerKickEvent event) {
        Player player = event.getPlayer();
        Log.debugLazy(() -> player.getName() + " was kicked with reason: " + event.getReason() + " | Leave message: " + event.getLeaveMessage() + " - In combat: " + this.playerManager.get(player).isInCombat());
        if (Conf.PUNISH_ON_KICK.asBool() && (!Conf.MATCH_KICK_REASON.asBool() || Conf.PUNISH_KICK_REASONS.asList().stream().anyMatch(reason -> event.getReason().toLowerCase().contains(reason.toLowerCase())))) {
            return;
        }
        CombatPlayer pvPlayer = this.playerManager.get(player);
        if (pvPlayer.isInCombat()) {
            pvPlayer.untag(UntagReason.KICKED);
        }
    }

    @EventHandler
    public final void onPlayerLogout(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        CombatPlayer combatPlayer = this.playerManager.get(player);
        Log.debug(player.getName() + " quit with message: " + event.getQuitMessage() + " - In combat: " + combatPlayer.isInCombat());
        if (combatPlayer.isInCombat() && !combatPlayer.hasPerm(Permissions.EXEMPT_COMBAT_LOG)) {
            this.playerManager.getConfigManager().getLog().logCombatLog(combatPlayer);
            CombatUtils.executeCommands(Conf.COMMANDS_ON_COMBATLOG.asList(), player, player.getName());
            this.playerManager.applyPunishments(combatPlayer);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerLogoutMonitor(PlayerQuitEvent event) {
        ScheduleUtils.runPlatformTask(() -> this.playerManager.removePlayer(this.playerManager.get(event.getPlayer())));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public final void onPlayerDeath(PlayerDeathEvent event) {
        if (CombatUtils.isWorldExcluded(event.getEntity().getWorld().getName())) {
            return;
        }
        this.deathHandler.processDeath(event);
    }

    @EventHandler
    public final void onPlayerCooldown(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        if (CombatUtils.isWorldExcluded(player.getWorld().getName())) {
            return;
        }
        Material type = e.getMaterial();
        if ((e.getAction() == Action.RIGHT_CLICK_BLOCK || e.getAction() == Action.RIGHT_CLICK_AIR) && Conf.ITEM_COOLDOWNS.asMap().containsKey(type)) {
            CombatPlayer combatPlayer = this.playerManager.get(player);
            if (combatPlayer.hasItemCooldown(type)) {
                String msg = Lang.ITEM_COOLDOWN.msgTimeUntil(combatPlayer.getItemCooldown(type));
                if (!msg.equals(this.msgCooldown.getIfPresent((Object)player.getUniqueId()))) {
                    combatPlayer.message(Lang.ITEM_COOLDOWN, TimeUtil.getDiffUntil(Lang.ITEM_COOLDOWN, (long)combatPlayer.getItemCooldown(type)));
                    this.msgCooldown.put((Object)player.getUniqueId(), (Object)msg);
                }
                e.setCancelled(true);
            } else if (!type.isEdible()) {
                ScheduleUtils.runPlatformTask(() -> combatPlayer.setItemCooldown(type, Conf.ITEM_COOLDOWNS.asMap().get(type)));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public final void onPlayerInteract(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        if (CombatUtils.isWorldExcluded(player.getWorld().getName()) || e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = e.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        CombatPlayer pvplayer = this.playerManager.get(player);
        Material type = e.getMaterial();
        if (type == Material.FLINT_AND_STEEL) {
            for (Player p : clickedBlock.getWorld().getPlayers()) {
                CombatPlayer target;
                if (player.equals((Object)p) || !clickedBlock.getWorld().equals((Object)p.getWorld()) || !player.canSee(p) || (target = this.playerManager.get(p)).hasPvPEnabled() && pvplayer.hasPvPEnabled() || !(clickedBlock.getLocation().distanceSquared(p.getLocation()) < 9.0)) continue;
                pvplayer.message(Lang.ATTACK_DENIED_OTHER, target.getName());
                e.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public final void onBucketEmpty(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        CombatPlayer combatPlayer = this.playerManager.get(player);
        Block clickedBlock = event.getBlockClicked();
        if (event.getBucket() == Material.LAVA_BUCKET) {
            for (Player p : clickedBlock.getWorld().getPlayers()) {
                if (player.equals((Object)p) || !clickedBlock.getWorld().equals((Object)p.getWorld()) || !player.canSee(p)) continue;
                CombatPlayer target = this.playerManager.get(p);
                Location playerLocation = p.getLocation();
                if (target.hasPvPEnabled() && combatPlayer.hasPvPEnabled() || playerLocation == null || !(clickedBlock.getLocation().distanceSquared(playerLocation) < 25.0)) continue;
                combatPlayer.message(Lang.ATTACK_DENIED_OTHER, target.getName());
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        CombatPlayer pvPlayer = this.playerManager.createPlayer(player, true);
        ScheduleUtils.runAsync(() -> {
            if (player.isOp() || pvPlayer.hasPerm(Permissions.ADMIN)) {
                Lang.sendQueuedMsgs(pvPlayer);
            }
        });
    }

    @EventHandler(ignoreCancelled=true)
    public final void onPlayerFish(PlayerFishEvent event) {
        Entity entity;
        Player player = event.getPlayer();
        if (CombatUtils.isWorldExcluded(player.getWorld().getName())) {
            return;
        }
        if (event.getState() == PlayerFishEvent.State.CAUGHT_ENTITY && (entity = event.getCaught()) instanceof Player) {
            Player caught = (Player)entity;
            ProtectionResult result = this.playerManager.checkProtection(player, caught);
            if (result.isProtected()) {
                event.setCancelled(true);
                event.getHook().setHookedEntity(null);
                Lang.messageProtection(result, player, caught);
            } else if (!Conf.IGNORE_NO_DMG_HITS.asBool()) {
                this.playerManager.getPlugin().getEntityListener().processDamage(player, caught);
            }
        }
    }

    @EventHandler
    public final void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (CombatUtils.isWorldExcluded(player.getWorld().getName())) {
            return;
        }
        CombatPlayer combatPlayer = this.playerManager.getUnchecked(player);
        if (combatPlayer == null) {
            return;
        }
        if (Conf.KILL_ABUSE_ENABLED.asBool() && Conf.RESPAWN_PROTECTION.asInt() != 0) {
            combatPlayer.setRespawnTime(System.currentTimeMillis());
        }
        if (combatPlayer.wasLastDeathPvP()) {
            CombatUtils.executeCommands(Conf.COMMANDS_ON_RESPAWN.asList(), player, player.getName());
        }
    }

    @EventHandler
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        CombatWorld.WorldOptionState optionState;
        Player player = event.getPlayer();
        CombatPlayer combatPlayer = this.playerManager.getUnchecked(player);
        if (combatPlayer == null) {
            return;
        }
        CombatWorld combatWorld = this.playerManager.getPlugin().getWorldManager().getWorld(player.getWorld());
        combatPlayer.setCombatWorld(combatWorld);
        if (combatPlayer.isNewbie() && combatPlayer.getNewbieTask() != null) {
            if (CombatUtils.isWorldExcluded(player.getWorld().getName())) {
                combatPlayer.getNewbieTask().pause();
            } else {
                combatPlayer.getNewbieTask().resume();
            }
        }
        if ((optionState = combatPlayer.getCombatWorld().isPvPForced()) == CombatWorld.WorldOptionState.NONE) {
            return;
        }
        if (combatPlayer.hasPvPEnabled() && optionState == CombatWorld.WorldOptionState.OFF) {
            combatPlayer.setPvP(false);
            combatPlayer.message(Lang.ERROR_PVP_TOGGLE_NO_PVP, new Object[0]);
            return;
        }
        if (!combatPlayer.hasPvPEnabled() && optionState == CombatWorld.WorldOptionState.ON) {
            combatPlayer.setPvP(true);
            combatPlayer.message(Lang.ERROR_PVP_TOGGLE_FORCE_PVP, new Object[0]);
        }
    }
}

