/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.chancesd.pvpmanager.manager.PlayerManager;
import me.chancesd.pvpmanager.player.CombatPlayer;
import me.chancesd.pvpmanager.player.ProtectionResult;
import me.chancesd.pvpmanager.setting.Conf;
import me.chancesd.pvpmanager.setting.Lang;
import me.chancesd.pvpmanager.utils.CombatUtils;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.projectiles.ProjectileSource;

public class EntityListener1_9
implements Listener {
    private final PlayerManager ph;
    private final Cache<UUID, Set<AreaEffectCloud>> potionMessageCache = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.SECONDS).build();
    private final Cache<UUID, AtomicInteger> elytraSpamCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.SECONDS).build();
    private static final int ELYTRA_SPAM_THRESHOLD = 3;

    public EntityListener1_9(PlayerManager ph) {
        this.ph = ph;
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityGlide(EntityToggleGlideEvent event) {
        if (!Conf.BLOCK_GLIDE_IN_COMBAT.asBool() || !event.isGliding()) {
            return;
        }
        Player player = (Player)event.getEntity();
        CombatPlayer combatPlayer = this.ph.get(player);
        if (combatPlayer.isInCombat()) {
            combatPlayer.message(Lang.ELYTRA_BLOCKED_IN_COMBAT, new Object[0]);
            event.setCancelled(true);
            UUID playerId = player.getUniqueId();
            AtomicInteger attemptCount = (AtomicInteger)this.elytraSpamCache.getIfPresent((Object)playerId);
            if (attemptCount == null) {
                attemptCount = new AtomicInteger(1);
                this.elytraSpamCache.put((Object)playerId, (Object)attemptCount);
            } else {
                int attempts = attemptCount.incrementAndGet();
                if (attempts >= 3) {
                    CombatUtils.removeElytra(player);
                    this.elytraSpamCache.invalidate((Object)playerId);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public final void onLingeringPotionSplash(AreaEffectCloudApplyEvent event) {
        Player player;
        AreaEffectCloud areaCloud;
        block7: {
            block6: {
                if (CombatUtils.isWorldExcluded(event.getEntity().getWorld().getName())) {
                    return;
                }
                areaCloud = event.getEntity();
                ProjectileSource areaCloudSource = areaCloud.getSource();
                if (event.getAffectedEntities().isEmpty() || !(areaCloudSource instanceof Player)) break block6;
                player = (Player)areaCloudSource;
                if (CombatUtils.hasHarmfulPotion(areaCloud)) break block7;
            }
            return;
        }
        ArrayList<LivingEntity> toRemove = new ArrayList<LivingEntity>();
        for (LivingEntity e : event.getAffectedEntities()) {
            Player attacked;
            ProtectionResult result;
            if (e.getType() != EntityType.PLAYER || e.equals((Object)player) || !(result = this.ph.checkProtection(player, attacked = (Player)e)).isProtected()) continue;
            toRemove.add(e);
            Set clouds = (Set)this.potionMessageCache.getIfPresent((Object)player.getUniqueId());
            if (clouds != null && clouds.contains(areaCloud)) continue;
            Lang.messageProtection(result, player, attacked);
            HashSet<AreaEffectCloud> newClouds = new HashSet<AreaEffectCloud>();
            newClouds.add(areaCloud);
            if (clouds != null) {
                newClouds.addAll(clouds);
            }
            this.potionMessageCache.put((Object)player.getUniqueId(), newClouds);
        }
        event.getAffectedEntities().removeAll(toRemove);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onLingeringPotionSplashMon(AreaEffectCloudApplyEvent event) {
        if (CombatUtils.isWorldExcluded(event.getEntity().getWorld().getName())) {
            return;
        }
        AreaEffectCloud areaCloud = event.getEntity();
        ProjectileSource areaCloudSource = areaCloud.getSource();
        if (event.getAffectedEntities().isEmpty() || !(areaCloudSource instanceof Player)) {
            return;
        }
        if (!CombatUtils.hasHarmfulPotion(areaCloud)) {
            return;
        }
        Player player = (Player)areaCloudSource;
        for (LivingEntity e : event.getAffectedEntities()) {
            Player attacked;
            ProtectionResult result;
            if (e.getType() != EntityType.PLAYER || e.equals((Object)player) || !(result = this.ph.checkProtection(player, attacked = (Player)e)).isVulnerable()) continue;
            this.ph.getPlugin().getEntityListener().processDamage(player, attacked);
        }
    }
}

