/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.integration.hook.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import me.chancesd.pvpmanager.PvPManager;
import me.chancesd.pvpmanager.player.CombatPlayer;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.setting.Lang;
import org.bukkit.ChatColor;

public class WorldGuardFlagHandler
extends FlagValueChangeHandler<StateFlag.State> {
    public static final Factory FACTORY = new Factory();
    private static StateFlag noProtectionFlag;
    private final PvPManager plugin = PvPManager.getInstance();

    public WorldGuardFlagHandler(Session session) {
        super(session, (Flag)noProtectionFlag);
    }

    public static void initializeFlags() {
        Log.infoColor(String.valueOf(ChatColor.DARK_PURPLE) + "Registering WorldGuard flags...");
        noProtectionFlag = WorldGuardFlagHandler.registerFlag("pvp-protection", false);
    }

    public static void shutdown() {
        WorldGuard.getInstance().getPlatform().getSessionManager().unregisterHandler((Handler.Factory)FACTORY);
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, StateFlag.State value) {
        Log.debug("Initial value: " + String.valueOf(value));
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State currentValue, StateFlag.State lastValue, MoveType moveType) {
        Log.debug("Changed value: " + String.valueOf(currentValue) + " from " + String.valueOf(lastValue));
        if (currentValue != StateFlag.State.DENY) {
            return true;
        }
        CombatPlayer cplayer = this.plugin.getPlayerManager().get(BukkitAdapter.adapt((Player)player));
        if (!cplayer.hasPvPEnabled()) {
            cplayer.setPvP(true);
            cplayer.message(Lang.PVP_FORCE_ENABLED_WG, new Object[0]);
        }
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State lastValue, MoveType moveType) {
        Log.debug("Absent value, last was: " + String.valueOf(lastValue));
        return true;
    }

    private static StateFlag registerFlag(String name, boolean def) {
        StateFlag flag;
        block2: {
            FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
            flag = new StateFlag(name, def);
            try {
                registry.register((Flag)flag);
            }
            catch (FlagConflictException | IllegalStateException e) {
                Flag existing = registry.get(name);
                if (!(existing instanceof StateFlag)) break block2;
                StateFlag stateFlag = (StateFlag)existing;
                return stateFlag;
            }
        }
        return flag;
    }

    public static StateFlag getNoProtectionFlag() {
        return noProtectionFlag;
    }

    public static class Factory
    extends Handler.Factory<WorldGuardFlagHandler> {
        public WorldGuardFlagHandler create(Session session) {
            return new WorldGuardFlagHandler(session);
        }
    }
}

