/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.gui.click.handler;

import com.artillexstudios.axgraves.libs.gui.click.ClickContext;
import com.artillexstudios.axgraves.libs.gui.click.action.GuiClickAction;
import com.artillexstudios.axgraves.libs.gui.click.action.RunnableGuiClickAction;
import com.artillexstudios.axgraves.libs.gui.click.controller.ClickController;
import com.artillexstudios.axgraves.libs.gui.click.handler.ClickHandler;
import com.artillexstudios.axgraves.libs.gui.exception.TriumphGuiException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class CompletableFutureClickHandler<P>
implements ClickHandler<P> {
    private final long timeout;
    private final TimeUnit unit;

    public CompletableFutureClickHandler() {
        this(6L, TimeUnit.SECONDS);
    }

    public CompletableFutureClickHandler(long timeout, @NotNull TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public void handle(@NotNull P player, @NotNull ClickContext context, @NotNull GuiClickAction<P> action, @NotNull ClickController controller) {
        if (!(action instanceof RunnableGuiClickAction)) {
            throw new TriumphGuiException("The click action type '" + action.getClass().getName() + "' is supported by the 'CompletableFutureClickHandler'.");
        }
        controller.completingLater(true);
        CompletableFuture.runAsync(() -> ((RunnableGuiClickAction)action).run(player, context)).orTimeout(this.timeout, this.unit).whenComplete((unused, throwable) -> controller.complete((Throwable)throwable));
    }
}

