/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.utils;

import com.artillexstudios.axgraves.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axgraves.libs.axapi.items.component.DataComponents;
import com.artillexstudios.axgraves.libs.axapi.items.component.type.CustomModelData;
import com.artillexstudios.axgraves.libs.axapi.items.component.type.DyedColor;
import com.artillexstudios.axgraves.libs.axapi.items.component.type.ItemEnchantments;
import com.artillexstudios.axgraves.libs.axapi.items.component.type.ItemLore;
import com.artillexstudios.axgraves.libs.axapi.items.component.type.ProfileProperties;
import com.artillexstudios.axgraves.libs.axapi.items.component.type.Unbreakable;
import com.artillexstudios.axgraves.libs.axapi.items.component.type.Unit;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.boostedyaml.block.implementation.Section;
import com.artillexstudios.axgraves.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axgraves.libs.axapi.utils.StringUtils;
import com.artillexstudios.axgraves.libs.kyori.key.Key;
import com.artillexstudios.axgraves.libs.kyori.text.Component;
import com.artillexstudios.axgraves.libs.kyori.text.minimessage.MiniMessage;
import com.artillexstudios.axgraves.libs.kyori.text.minimessage.tag.resolver.Placeholder;
import com.artillexstudios.axgraves.libs.kyori.text.minimessage.tag.resolver.TagResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class ItemBuilder {
    private static final UUID NIL_UUID = new UUID(0L, 0L);
    private final List<ItemFlag> flags = new ArrayList<ItemFlag>(4);
    private final WrappedItemStack stack;
    private final TagResolver[] resolvers;

    public ItemBuilder(Map<Object, Object> map, TagResolver ... resolvers) {
        String snbt;
        this.resolvers = resolvers;
        String type = (String)map.get("type");
        if (type == null) {
            type = (String)map.getOrDefault("material", "stone");
        }
        this.stack = (snbt = (String)map.get("snbt")) != null ? NMSHandlers.getNmsHandler().wrapItem(snbt) : WrappedItemStack.wrap(new ItemStack(ItemBuilder.getMaterial(type)));
        Optional.ofNullable(map.get("item-flags")).ifPresent(flags -> this.flags.addAll(ItemBuilder.getItemFlags((List)flags)));
        Optional.ofNullable(map.get("name")).ifPresent(name -> this.setName((String)name, this.resolvers));
        Optional.ofNullable(map.get("color")).ifPresent(color -> this.setColor((String)color));
        Optional.ofNullable(map.get("texture")).ifPresent(string -> this.setTextureValue((String)string));
        Optional.ofNullable(map.get("custom-model-data")).ifPresent(number -> {
            if (number instanceof Integer) {
                Integer num = (Integer)number;
                this.legacyModelData(num);
            } else if (number instanceof Map) {
                Map model = (Map)number;
                this.customModelData(model);
            }
        });
        Optional.ofNullable(map.get("amount")).ifPresent(amount -> this.stack.setAmount((Integer)amount));
        Optional.ofNullable(map.get("glow")).ifPresent(glow -> this.glow((Boolean)glow));
        Optional.ofNullable(map.get("lore")).ifPresent(lore -> this.setLore((List<String>)((List)lore), this.resolvers));
        Optional.ofNullable(map.get("enchants")).ifPresent(enchants -> this.addEnchants(ItemBuilder.createEnchantmentsMap((List)enchants)));
        Optional.ofNullable(map.get("potion")).ifPresent(potion -> this.setPotion((String)potion));
        Optional.ofNullable(map.get("unbreakable")).ifPresent(unbreakable -> this.stack.set(DataComponents.unbreakable(), new Unbreakable(!this.flags.contains(ItemFlag.HIDE_UNBREAKABLE))));
        Optional.ofNullable(map.get("item-model")).ifPresent(model -> this.stack.set(DataComponents.itemModel(), Key.key((String)model)));
        try {
            if (this.flags.contains(ItemFlag.HIDE_POTION_EFFECTS)) {
                this.stack.set(DataComponents.hideAdditionalTooltip(), Unit.INSTANCE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ItemBuilder(Map<Object, Object> map, Map<String, String> replacements) {
        this(map, ItemBuilder.mapResolvers(replacements));
    }

    public ItemBuilder(Map<Object, Object> map) {
        this(map, TagResolver.resolver(new TagResolver[0]));
    }

    public ItemBuilder(Section section) {
        this(ItemBuilder.mapSection(section), TagResolver.resolver(new TagResolver[0]));
    }

    public ItemBuilder(Section section, TagResolver ... resolvers) {
        this(ItemBuilder.mapSection(section), resolvers);
    }

    public ItemBuilder(Section section, Map<String, String> replacements) {
        this(ItemBuilder.mapSection(section), ItemBuilder.mapResolvers(replacements));
    }

    public ItemBuilder(ItemStack itemStack, TagResolver ... resolvers) {
        this.resolvers = resolvers;
        this.stack = WrappedItemStack.wrap(itemStack);
    }

    public ItemBuilder(ItemStack itemStack) {
        this.resolvers = new TagResolver[]{TagResolver.resolver(new TagResolver[0])};
        this.stack = WrappedItemStack.wrap(itemStack);
    }

    public ItemBuilder(Material material, TagResolver ... resolvers) {
        this.resolvers = resolvers;
        this.stack = WrappedItemStack.wrap(new ItemStack(material));
    }

    public ItemBuilder(Material material) {
        this.resolvers = new TagResolver[]{TagResolver.resolver(new TagResolver[0])};
        this.stack = WrappedItemStack.wrap(new ItemStack(material));
    }

    private static Material getMaterial(String name) {
        Material material = Material.matchMaterial((String)name.toUpperCase(Locale.ENGLISH));
        return material != null ? material : Material.BEDROCK;
    }

    public static TagResolver[] mapResolvers(Map<String, String> replacements) {
        TagResolver[] resolvers = new TagResolver[replacements.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            resolvers[i] = Placeholder.parsed(entry.getKey().replace("%", ""), entry.getValue());
            ++i;
        }
        return resolvers;
    }

    public static Map<Object, Object> mapSection(Section section) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Object key : section.getKeys()) {
            map.put(key.toString(), section.get(key.toString()));
        }
        return map;
    }

    @NotNull
    private static Map<Enchantment, Integer> createEnchantmentsMap(@NotNull List<String> enchantments) {
        HashMap<Enchantment, Integer> enchantsMap = new HashMap<Enchantment, Integer>(enchantments.size());
        for (String enchantment : enchantments) {
            int level;
            String[] enchant = enchantment.split(":");
            Enchantment ench = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchant[0]));
            if (ench == null) continue;
            try {
                level = Integer.parseInt(enchant[1]);
            }
            catch (Exception exception) {
                continue;
            }
            enchantsMap.put(ench, level);
        }
        return enchantsMap;
    }

    @NotNull
    private static List<ItemFlag> getItemFlags(@NotNull List<String> flags) {
        ArrayList<ItemFlag> flagList = new ArrayList<ItemFlag>(flags.size());
        for (String flag : flags) {
            ItemFlag itemFlag;
            try {
                itemFlag = ItemFlag.valueOf((String)flag.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                continue;
            }
            flagList.add(itemFlag);
        }
        return flagList;
    }

    public static String toTagResolver(String string, TagResolver ... resolvers) {
        if (!string.contains("%")) {
            return string;
        }
        char[] chars = string.toCharArray();
        int start = -1;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch != '%') continue;
            if (start == -1) {
                start = i;
                continue;
            }
            StringBuilder builder = new StringBuilder();
            for (int j = start; j <= i; ++j) {
                builder.append(chars[j]);
            }
            if (ItemBuilder.contains(builder.toString(), resolvers)) {
                chars[start] = 60;
                chars[i] = 62;
            }
            start = -1;
        }
        return new String(chars);
    }

    public static boolean contains(String string, TagResolver ... resolvers) {
        for (TagResolver resolver : resolvers) {
            TagResolver.Single s;
            if (!(resolver instanceof TagResolver.Single) || !string.contains((s = (TagResolver.Single)resolver).key())) continue;
            return true;
        }
        return false;
    }

    public static List<String> toTagResolver(List<String> lore, TagResolver ... resolvers) {
        ArrayList<String> newLore = new ArrayList<String>(lore);
        for (int i = 0; i < lore.size(); ++i) {
            String toFormat = (String)newLore.get(i);
            newLore.set(i, ItemBuilder.toTagResolver(toFormat, resolvers));
        }
        return newLore;
    }

    public ItemBuilder setPotion(String potion) {
        this.stack.set(DataComponents.potionType(), PotionType.valueOf((String)potion.toUpperCase(Locale.ENGLISH)));
        return this;
    }

    public ItemBuilder setName(String name) {
        this.setName(name, this.resolvers);
        return this;
    }

    public ItemBuilder setName(String name, Map<String, String> replacements) {
        AtomicReference<String> toFormat = new AtomicReference<String>(name);
        replacements.forEach((pattern, replacement) -> toFormat.set(((String)toFormat.get()).replace((CharSequence)pattern, (CharSequence)replacement)));
        this.setName(toFormat.get(), TagResolver.resolver(new TagResolver[0]));
        return this;
    }

    public ItemBuilder setName(String name, TagResolver ... resolvers) {
        this.stack.set(DataComponents.customName(), StringUtils.format(ItemBuilder.toTagResolver(name, resolvers), resolvers));
        return this;
    }

    public ItemBuilder setColor(String colorString) {
        String[] rgb = colorString.replace(" ", "").split(",");
        Color color = Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2]));
        this.stack.set(DataComponents.dyedColor(), new DyedColor(color, this.flags.contains(ItemFlag.HIDE_DYE)));
        return this;
    }

    public ItemBuilder glow(boolean glow) {
        if (glow) {
            this.stack.set(DataComponents.enchantmentGlintOverride(), true);
        }
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int level) {
        ItemEnchantments enchants = this.stack.get(DataComponents.enchantments());
        enchants = enchants.add(enchantment, level);
        if (this.flags.contains(ItemFlag.HIDE_ENCHANTS)) {
            enchants = enchants.withTooltip(false);
        }
        this.stack.set(DataComponents.enchantments(), enchants);
        return this;
    }

    public ItemBuilder legacyModelData(Integer modelData) {
        this.stack.set(DataComponents.customModelData(), new CustomModelData(List.of(), List.of(), modelData == null ? List.of() : List.of(Float.valueOf(modelData.floatValue())), List.of()));
        return this;
    }

    public ItemBuilder customModelData(Map<Object, Object> modelData) {
        this.stack.set(DataComponents.customModelData(), new CustomModelData(modelData.getOrDefault("strings", List.of()), modelData.getOrDefault("flags", List.of()), Lists.transform(modelData.getOrDefault("floats", List.of()), num -> Float.valueOf(num.floatValue())), Lists.transform(modelData.getOrDefault("colors", List.of()), a -> {
            String[] rgb = a.replace(" ", "").split(",");
            Color color = Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2]));
            return color.asRGB();
        })));
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        this.setLore(lore, this.resolvers);
        return this;
    }

    public ItemBuilder setLore(List<String> lore, Map<String, String> replacements) {
        ArrayList<String> newList = new ArrayList<String>(replacements.size());
        for (String line : lore) {
            AtomicReference<String> toFormat = new AtomicReference<String>(line);
            replacements.forEach((pattern, replacement) -> toFormat.set(((String)toFormat.get()).replace((CharSequence)pattern, (CharSequence)replacement)));
            newList.add(toFormat.get());
        }
        this.setLore(newList, TagResolver.resolver(new TagResolver[0]));
        return this;
    }

    public ItemBuilder setLore(List<String> lore, TagResolver ... resolvers) {
        this.stack.set(DataComponents.lore(), new ItemLore(StringUtils.formatList(ItemBuilder.toTagResolver(lore, resolvers), resolvers)));
        return this;
    }

    public ItemBuilder setTextureValue(String texture) {
        ProfileProperties properties = new ProfileProperties(NIL_UUID, "axapi");
        texture = StringUtils.formatToString(ItemBuilder.toTagResolver(texture, new TagResolver[0]), this.resolvers);
        properties.put("textures", new ProfileProperties.Property("textures", texture, null));
        this.stack.set(DataComponents.profile(), properties);
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.stack.setAmount(amount);
        return this;
    }

    public ItemBuilder addEnchants(Map<Enchantment, Integer> enchantments) {
        enchantments.forEach(this::addEnchantment);
        return this;
    }

    public Map<Object, Object> serialize(boolean snbt) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (snbt) {
            map.put("snbt", this.stack.toSNBT());
        } else {
            ProfileProperties profileProperties;
            int data;
            List<Component> lore;
            map.put("type", this.stack.get(DataComponents.material()).name());
            Component name = this.stack.get(DataComponents.customName());
            if (name != Component.empty()) {
                map.put("name", MiniMessage.miniMessage().serialize(name));
            }
            if (!(lore = this.stack.get(DataComponents.lore()).lines()).isEmpty()) {
                map.put("lore", Lists.transform(lore, a -> (String)MiniMessage.miniMessage().serialize(a)));
            }
            map.put("amount", this.stack.getAmount());
            CustomModelData modelData = this.stack.get(DataComponents.customModelData());
            if (!modelData.floats().isEmpty() && modelData.colors().isEmpty() && modelData.flags().isEmpty() && modelData.strings().isEmpty() && (data = modelData.floats().get(0).intValue()) != 0) {
                map.put("custom-model-data", data);
            }
            if ((profileProperties = this.stack.get(DataComponents.profile())) != null) {
                map.put("texture", profileProperties.properties().get((Object)"textures").stream().findFirst().orElse(new ProfileProperties.Property("", "", null)).value());
            }
        }
        return map;
    }

    public ItemStack get() {
        this.stack.finishEdit();
        return this.stack.toBukkit();
    }

    public ItemStack clonedGet() {
        return this.get().clone();
    }
}

