/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.packetentity.tracker;

import com.artillexstudios.axgraves.libs.axapi.AxPlugin;
import com.artillexstudios.axgraves.libs.axapi.collections.RawReferenceOpenHashSet;
import com.artillexstudios.axgraves.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axgraves.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axgraves.libs.axapi.packetentity.PacketEntity;
import com.artillexstudios.axgraves.libs.axapi.reflection.FastFieldAccessor;
import com.artillexstudios.axgraves.libs.axapi.utils.ExceptionReportingScheduledThreadPool;
import com.artillexstudios.axgraves.libs.axapi.utils.LogUtils;
import com.artillexstudios.axgraves.libs.axapi.utils.PaperUtils;
import com.artillexstudios.axgraves.libs.axapi.utils.Version;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class EntityTracker {
    private static final boolean folia = PaperUtils.isFolia();
    private final ConcurrentHashMap<Integer, TrackedEntity> entityMap = new ConcurrentHashMap();
    private final FastFieldAccessor accessor;
    private final JavaPlugin instance;
    private ScheduledExecutorService service;

    public EntityTracker() {
        this.accessor = FastFieldAccessor.forClassField(String.format("com.artillexstudios.axgraves.libs.axapi.nms.%s.entity.PacketEntity", Version.getServerVersion().nmsVersion), "tracker");
        this.instance = AxPlugin.getPlugin(AxPlugin.class);
    }

    public void startTicking() {
        this.shutdown();
        this.service = new ExceptionReportingScheduledThreadPool((int)((Integer)AxPlugin.flags().PACKET_ENTITY_TRACKER_THREADS.get()), new ThreadFactoryBuilder().setNameFormat(this.instance.getName() + "-EntityTracker-%s").build());
        this.service.scheduleAtFixedRate(() -> {
            try {
                this.process();
            }
            catch (Exception exception) {
                if (exception instanceof ConcurrentModificationException) {
                    if (((Boolean)AxPlugin.flags().DEBUG.get()).booleanValue()) {
                        LogUtils.error("Caught ConcurrentModificationException when processing packet entities!", exception);
                    }
                    return;
                }
                LogUtils.error("An unexpected error occurred while processing packet entities via the tracker!", exception);
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        if (this.service == null) {
            return;
        }
        this.service.shutdown();
        try {
            this.service.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException exception) {
            LogUtils.error("Failed to shut down EntityTracker service!", exception);
        }
    }

    public PacketEntity getById(int id) {
        TrackedEntity entity = this.entityMap.get(id);
        return entity == null ? null : entity.entity;
    }

    public void addEntity(PacketEntity entity) {
        TrackedEntity trackedEntity = new TrackedEntity(entity);
        this.accessor.set(entity, trackedEntity);
        this.entityMap.put(entity.id(), trackedEntity);
        trackedEntity.updateTracking(TrackedEntity.getPlayersInWorld(entity.location().getWorld()));
    }

    public void removeEntity(PacketEntity entity) {
        TrackedEntity trackedEntity = this.entityMap.remove(entity.id());
        if (trackedEntity != null) {
            trackedEntity.broadcastRemove();
        }
        this.accessor.set(entity, null);
    }

    public void untrackFor(ServerPlayerWrapper player) {
        for (TrackedEntity tracker : this.entityMap.values()) {
            tracker.untrack(player);
        }
    }

    public void process() {
        HashMap<World, List<ServerPlayerWrapper>> tracking = new HashMap<World, List<ServerPlayerWrapper>>((int)Math.ceil((double)Bukkit.getWorlds().size() / 0.75));
        for (World world : Bukkit.getWorlds()) {
            tracking.put(world, TrackedEntity.getPlayersInWorld(world));
        }
        Iterator<TrackedEntity> iterator = this.entityMap.values().iterator();
        for (int i = 0; i < (Integer)AxPlugin.flags().PACKET_ENTITY_TRACKER_THREADS.get(); ++i) {
            this.service.execute(() -> {
                while (true) {
                    TrackedEntity tracked;
                    Iterator iterator2 = iterator;
                    synchronized (iterator2) {
                        if (!iterator.hasNext()) {
                            break;
                        }
                        tracked = (TrackedEntity)iterator.next();
                    }
                    tracked.preTick();
                    tracked.updateTracking((List)tracking.get(tracked.world));
                    if (!tracked.hasViewers()) continue;
                    tracked.entity.sendChanges();
                }
            });
        }
    }

    public static class TrackedEntity {
        public final ReferenceSet<Object> seenBy = ReferenceSets.synchronize(new RawReferenceOpenHashSet());
        private final PacketEntity entity;
        private final World world;
        private List<ServerPlayerWrapper> lastTrackerCandidates;
        private boolean hasViewers = false;

        public TrackedEntity(PacketEntity entity) {
            this.entity = entity;
            this.world = this.entity.location().getWorld();
        }

        public static List<ServerPlayerWrapper> getPlayersInWorld(World world) {
            if (world == null) {
                return ImmutableList.of();
            }
            if (folia) {
                List players = world.getPlayers();
                ArrayList<ServerPlayerWrapper> wrapper = new ArrayList<ServerPlayerWrapper>(players.size());
                for (Player player : players) {
                    wrapper.add(ServerPlayerWrapper.wrap(player));
                }
                return wrapper;
            }
            return NMSHandlers.getNmsHandler().players(world);
        }

        public void updateTracking(@NotNull List<ServerPlayerWrapper> newTrackerCandidates) {
            List<ServerPlayerWrapper> oldTrackerCandidates = this.lastTrackerCandidates;
            this.lastTrackerCandidates = newTrackerCandidates;
            for (ServerPlayerWrapper raw : newTrackerCandidates) {
                this.updatePlayer(raw);
            }
            if (oldTrackerCandidates != null && oldTrackerCandidates.size() == newTrackerCandidates.size() && oldTrackerCandidates.equals(newTrackerCandidates)) {
                return;
            }
            for (Object player : RawReferenceOpenHashSet.rawSet(this.seenBy)) {
                if (player == null) continue;
                ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
                if (!newTrackerCandidates.isEmpty() && newTrackerCandidates.contains(wrapper)) continue;
                this.updatePlayer(wrapper);
            }
        }

        public void updatePlayer(ServerPlayerWrapper player) {
            boolean flag;
            int dz;
            int dx = (int)player.getX() - (int)this.entity.location().getX();
            int d1 = dx * dx + (dz = (int)player.getZ() - (int)this.entity.location().getZ()) * dz;
            boolean bl = flag = d1 <= this.entity.viewDistanceSquared();
            if (flag && !this.entity.canSee((Player)player.wrapped())) {
                flag = false;
            }
            if (flag) {
                this.hasViewers = true;
                if (this.seenBy.add(player.asMinecraft())) {
                    this.entity.addPairing((Player)player.wrapped());
                }
            } else if (this.seenBy.remove(player.asMinecraft())) {
                this.entity.removePairing((Player)player.wrapped());
            }
        }

        public void untrack(ServerPlayerWrapper player) {
            if (!this.seenBy.remove(player.asMinecraft())) {
                return;
            }
            this.entity.removePairing((Player)player.wrapped());
        }

        public void broadcast(Object packet) {
            this.seenBy.forEach(player -> NMSHandlers.getNmsHandler().sendPacket(ServerPlayerWrapper.wrap(player), packet));
        }

        public void broadcastRemove() {
            this.seenBy.forEach(player -> this.entity.removePairing((Player)ServerPlayerWrapper.wrap(player).wrapped()));
        }

        public void preTick() {
            this.hasViewers = false;
        }

        public boolean hasViewers() {
            return this.hasViewers;
        }
    }
}

