/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.nms.v1_18_R2.utils;

import com.artillexstudios.axgraves.libs.axapi.utils.BossBar;
import com.artillexstudios.axgraves.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axgraves.libs.kyori.text.Component;
import com.artillexstudios.axgraves.libs.kyori.text.serializer.gson.GsonComponentSerializer;
import com.google.gson.JsonElement;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.BossBattle;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class BossBar
implements com.artillexstudios.axgraves.libs.axapi.utils.BossBar {
    private final UUID uuid = UUID.randomUUID();
    private final HashSet<BossBar.Flag> flags = new HashSet(4);
    private final Set<Player> viewers = Collections.newSetFromMap(new WeakHashMap());
    private final PacketPlayOutBoss removePacket = PacketPlayOutBoss.a((UUID)this.uuid);
    private Component title;
    private BossBar.Color color;
    private BossBar.Style style;
    private float progress;
    private PacketPlayOutBoss addPacket;

    public BossBar(Component title, float progress, BossBar.Color color, BossBar.Style style, BossBar.Flag ... flags) {
        Validate.inclusiveBetween((double)0.0, (double)1.0, (double)progress);
        this.title = title;
        this.progress = progress;
        this.color = color;
        this.style = style;
        this.flags.addAll(Arrays.asList(flags));
        this.updateAddPacket();
    }

    private static int encodeProperties(Set<BossBar.Flag> flags) {
        boolean darkenSky = flags.contains((Object)BossBar.Flag.DARKEN_SCREEN);
        boolean dragonMusic = flags.contains((Object)BossBar.Flag.PLAY_BOSS_MUSIC);
        boolean thickenFog = flags.contains((Object)BossBar.Flag.CREATE_WORLD_FOG);
        return BossBar.encodeProperties(darkenSky, dragonMusic, thickenFog);
    }

    private static int encodeProperties(boolean darkenSky, boolean dragonMusic, boolean thickenFog) {
        int i = 0;
        if (darkenSky) {
            i |= 1;
        }
        if (dragonMusic) {
            i |= 2;
        }
        if (thickenFog) {
            i |= 4;
        }
        return i;
    }

    @Override
    public void show(Player player) {
        if (this.viewers.add(player)) {
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.b.a((Packet)this.addPacket);
        }
    }

    @Override
    public void hide(Player player) {
        if (this.viewers.remove(player)) {
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.b.a((Packet)this.removePacket);
        }
    }

    @Override
    public void setStyle(BossBar.Style style) {
        this.style = style;
        this.updateAddPacket();
        this.updateStyle();
    }

    @Override
    public void setColor(BossBar.Color color) {
        this.color = color;
        this.updateAddPacket();
        this.updateStyle();
    }

    @Override
    public void addFlags(BossBar.Flag ... flag) {
        this.flags.addAll(Arrays.asList(flag));
        this.updateAddPacket();
        this.updateFlags();
    }

    @Override
    public void removeFlags(BossBar.Flag ... flag) {
        Arrays.asList(flag).forEach(this.flags::remove);
        this.updateAddPacket();
        this.updateFlags();
    }

    @Override
    public Set<BossBar.Flag> getFlags() {
        return Set.copyOf(this.flags);
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(Component title) {
        this.title = title;
        this.updateAddPacket();
        this.updateTitle();
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(float progress) {
        Validate.inclusiveBetween((double)0.0, (double)1.0, (double)progress);
        this.progress = progress;
        this.updateAddPacket();
        this.updateProgress();
    }

    @Override
    public void remove() {
        for (Player viewer : this.viewers) {
            EntityPlayer serverPlayer = ((CraftPlayer)viewer).getHandle();
            serverPlayer.b.a((Packet)this.removePacket);
        }
    }

    private void updateTitle() {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(this.uuid);
        buf.d(3);
        buf.a((IChatBaseComponent)IChatBaseComponent.ChatSerializer.a((JsonElement)GsonComponentSerializer.gson().serializer().toJsonTree(this.title)));
        PacketPlayOutBoss titlePacket = new PacketPlayOutBoss(buf);
        buf.release();
        for (Player viewer : this.viewers) {
            EntityPlayer serverPlayer = ((CraftPlayer)viewer).getHandle();
            serverPlayer.b.a((Packet)titlePacket);
        }
    }

    private void updateProgress() {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(this.uuid);
        buf.d(2);
        buf.writeFloat(this.progress);
        PacketPlayOutBoss progressPacket = new PacketPlayOutBoss(buf);
        buf.release();
        for (Player viewer : this.viewers) {
            EntityPlayer serverPlayer = ((CraftPlayer)viewer).getHandle();
            serverPlayer.b.a((Packet)progressPacket);
        }
    }

    private void updateStyle() {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(this.uuid);
        buf.d(4);
        buf.a((Enum)BossBattle.BarColor.a((String)this.color.getInternalName()));
        buf.a((Enum)BossBattle.BarStyle.a((String)this.style.getInternalName()));
        PacketPlayOutBoss progressPacket = new PacketPlayOutBoss(buf);
        buf.release();
        for (Player viewer : this.viewers) {
            EntityPlayer serverPlayer = ((CraftPlayer)viewer).getHandle();
            serverPlayer.b.a((Packet)progressPacket);
        }
    }

    private void updateFlags() {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(this.uuid);
        buf.d(5);
        buf.writeByte(BossBar.encodeProperties(this.flags));
        PacketPlayOutBoss progressPacket = new PacketPlayOutBoss(buf);
        buf.release();
        for (Player viewer : this.viewers) {
            EntityPlayer serverPlayer = ((CraftPlayer)viewer).getHandle();
            serverPlayer.b.a((Packet)progressPacket);
        }
    }

    private void updateAddPacket() {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(this.uuid);
        buf.d(0);
        buf.a((IChatBaseComponent)ComponentSerializer.INSTANCE.toVanilla(this.title));
        buf.writeFloat(this.progress);
        buf.a((Enum)BossBattle.BarColor.a((String)this.color.getInternalName()));
        buf.a((Enum)BossBattle.BarStyle.a((String)this.style.getInternalName()));
        buf.writeByte(BossBar.encodeProperties(this.flags));
        this.addPacket = new PacketPlayOutBoss(buf);
        buf.release();
    }
}

