/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.nms.v1_18_R2.entity;

import com.artillexstudios.axgraves.libs.axapi.nms.v1_18_R2.items.WrappedItemStack;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.serializer.EntityDataAccessor;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.serializer.EntityDataSerializers;
import com.artillexstudios.axgraves.libs.axapi.reflection.FastFieldAccessor;
import com.artillexstudios.axgraves.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axgraves.libs.axapi.utils.ParticleArguments;
import com.artillexstudios.axgraves.libs.kyori.text.Component;
import com.mojang.math.Vector3fa;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.core.Vector3f;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Particle;
import org.bukkit.craftbukkit.v1_18_R2.CraftParticle;
import org.bukkit.entity.Pose;
import org.bukkit.util.EulerAngle;

public class Serializers {
    private static final FastFieldAccessor nmsStack = FastFieldAccessor.forClassField(WrappedItemStack.class, "parent");
    private static final EnumMap<EntityDataSerializers.Type, Transformer<?>> typeTransformers = new EnumMap(EntityDataSerializers.Type.class);

    public static <T, Z> Transformer<Z> transformer(EntityDataAccessor<T> accessor) {
        return typeTransformers.get((Object)accessor.serializers().type());
    }

    static {
        typeTransformers.put(EntityDataSerializers.Type.BYTE, new Transformer<Byte>(){

            @Override
            public Byte transform(Object other) {
                return (Byte)other;
            }

            @Override
            public DataWatcherSerializer<Byte> serializer() {
                return DataWatcherRegistry.a;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.INT, new Transformer<Integer>(){

            @Override
            public Integer transform(Object other) {
                return (Integer)other;
            }

            @Override
            public DataWatcherSerializer<Integer> serializer() {
                return DataWatcherRegistry.b;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.FLOAT, new Transformer<Float>(){

            @Override
            public Float transform(Object other) {
                return (Float)other;
            }

            @Override
            public DataWatcherSerializer<Float> serializer() {
                return DataWatcherRegistry.c;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.STRING, new Transformer<String>(){

            @Override
            public String transform(Object other) {
                return (String)other;
            }

            @Override
            public DataWatcherSerializer<String> serializer() {
                return DataWatcherRegistry.d;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.COMPONENT, new Transformer<IChatBaseComponent>(){

            @Override
            public IChatBaseComponent transform(Object other) {
                return (IChatBaseComponent)ComponentSerializer.INSTANCE.toVanilla((Component)other);
            }

            @Override
            public DataWatcherSerializer<IChatBaseComponent> serializer() {
                return DataWatcherRegistry.e;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.OPTIONAL_COMPONENT, new Transformer<Optional<IChatBaseComponent>>(){

            @Override
            public Optional<IChatBaseComponent> transform(Object other) {
                return ((Optional)other).map(ComponentSerializer.INSTANCE::toVanilla);
            }

            @Override
            public DataWatcherSerializer<Optional<IChatBaseComponent>> serializer() {
                return DataWatcherRegistry.f;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.ITEM_STACK, new Transformer<ItemStack>(){

            @Override
            public ItemStack transform(Object other) {
                return (ItemStack)nmsStack.get(other);
            }

            @Override
            public DataWatcherSerializer<ItemStack> serializer() {
                return DataWatcherRegistry.g;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.BOOLEAN, new Transformer<Boolean>(){

            @Override
            public Boolean transform(Object other) {
                return (Boolean)other;
            }

            @Override
            public DataWatcherSerializer<Boolean> serializer() {
                return DataWatcherRegistry.i;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.PARTICLE, new Transformer<ParticleParam>(){

            @Override
            public ParticleParam transform(Object other) {
                ParticleArguments arguments = (ParticleArguments)other;
                return CraftParticle.toNMS((Particle)arguments.particle(), (Object)arguments.data());
            }

            @Override
            public DataWatcherSerializer<ParticleParam> serializer() {
                return DataWatcherRegistry.j;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.ROTATIONS, new Transformer<Vector3f>(){

            private static Vector3f toRotations(EulerAngle eulerAngle) {
                return new Vector3f((float)Math.toDegrees(eulerAngle.getX()), (float)Math.toDegrees(eulerAngle.getY()), (float)Math.toDegrees(eulerAngle.getZ()));
            }

            @Override
            public Vector3f transform(Object other) {
                return 10.toRotations((EulerAngle)other);
            }

            @Override
            public DataWatcherSerializer<Vector3f> serializer() {
                return DataWatcherRegistry.k;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.POSE, new Transformer<EntityPose>(){
            private static final EntityPose[] poses = EntityPose.values();

            @Override
            public EntityPose transform(Object other) {
                return poses[((Pose)other).ordinal()];
            }

            @Override
            public DataWatcherSerializer<EntityPose> serializer() {
                return DataWatcherRegistry.s;
            }
        });
        typeTransformers.put(EntityDataSerializers.Type.VECTOR3, new Transformer<Vector3fa>(){

            @Override
            public Vector3fa transform(Object other) {
                throw new RuntimeException("Unsupported type!");
            }

            @Override
            public DataWatcherSerializer<Vector3fa> serializer() {
                throw new RuntimeException("Unsupported type!");
            }
        });
    }

    public static interface Transformer<Z> {
        public Z transform(Object var1);

        public DataWatcherSerializer<Z> serializer();
    }
}

