/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.nms.v1_18_R1;

import com.artillexstudios.axgraves.libs.axapi.libs.math3.distribution.EnumeratedDistribution;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_18_R1.utils.IBlockDataListCopier;
import com.artillexstudios.axgraves.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axgraves.libs.axapi.reflection.FastFieldAccessor;
import com.artillexstudios.axgraves.libs.axapi.selection.Cuboid;
import com.artillexstudios.axgraves.libs.axapi.selection.ParallelBlockSetter;
import com.artillexstudios.axgraves.libs.axapi.utils.PaperUtils;
import com.destroystokyo.paper.util.maplist.IBlockDataList;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.block.data.CraftBlockData;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelBlockSetterImpl
implements ParallelBlockSetter {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final ExecutorService parallelExecutor = Executors.newFixedThreadPool(8);
    private static final Logger log = LoggerFactory.getLogger(ParallelBlockSetterImpl.class);
    private static final ArrayList<FastFieldAccessor> accessors = new ArrayList();
    private static final FastFieldAccessor dataAccessor = FastFieldAccessor.forClassField(DataPaletteBlock.class, "d");
    private static final FastFieldAccessor statesAccessor = FastFieldAccessor.forClassField(ChunkSection.class, "i");
    private static final Field storage = ClassUtils.INSTANCE.getDeclaredField("net.minecraft.world.level.chunk.DataPaletteBlock$c", "b");
    private static final IBlockData[] presetBlockStates = new IBlockData[]{Blocks.b.n()};
    private final WorldServer level;

    public ParallelBlockSetterImpl(World world) {
        this.level = ((CraftWorld)world).getHandle();
    }

    public void copyFields(ChunkSection fromSection, ChunkSection toSection) {
        Class<?> storageClass;
        for (FastFieldAccessor accessor : accessors) {
            if (accessor.getField().getType() == Short.TYPE) {
                accessor.setShort(toSection, accessor.getShort(fromSection));
                continue;
            }
            if (accessor.getField().getType() == Integer.TYPE) {
                accessor.setInt(toSection, accessor.getInt(fromSection));
                continue;
            }
            if (accessor.getField().getType() == DataPaletteBlock.class) {
                DataPaletteBlock container = (DataPaletteBlock)accessor.get(fromSection);
                accessor.set(toSection, container.d());
                continue;
            }
            if (PaperUtils.isPaper() && accessor.getField().getType() == IBlockDataList.class) {
                accessor.set(toSection, IBlockDataListCopier.copy((IBlockDataList)accessor.get(fromSection)));
                continue;
            }
            if (accessor.getField().getType() == long[].class) {
                long[] longs = (long[])accessor.get(fromSection);
                if (longs != null) {
                    accessor.set(toSection, Arrays.copyOf(longs, longs.length));
                    continue;
                }
                accessor.set(toSection, null);
                continue;
            }
            log.error("No copier for class {}; classname: {} field name {} typename: {}!", new Object[]{accessor.getField().getType(), accessor.getField().getType().getName(), accessor.getField().getName(), accessor.getField().getType().getTypeName()});
        }
        DataPaletteBlock container = (DataPaletteBlock)statesAccessor.get(toSection);
        Object data = dataAccessor.get(container);
        try {
            storageClass = storage.get(data).getClass();
        }
        catch (Exception exception) {
            log.error("An unexpected error occurred while accessing states!", (Throwable)exception);
            return;
        }
        if (storageClass == ZeroBitStorage.class) {
            statesAccessor.set(toSection, new DataPaletteBlock((Registry)Block.p, (Object)Blocks.a.n(), DataPaletteBlock.e.d, (Object[])presetBlockStates));
        }
    }

    public ChunkSection copy(ChunkSection section) {
        try {
            ChunkSection newSection = (ChunkSection)ClassUtils.INSTANCE.newInstance(ChunkSection.class);
            this.copyFields(section, newSection);
            return newSection;
        }
        catch (Exception exception) {
            log.error("An unexpected issue occurred while initializing ParallelBlockSetter. Is your version supported?", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void fill(Cuboid selection, EnumeratedDistribution<BlockData> distribution, IntConsumer consumer) {
        AtomicInteger blockCount = new AtomicInteger();
        int chunkMinX = selection.getMinX() >> 4;
        int chunkMaxX = selection.getMaxX() >> 4;
        int chunkMinZ = selection.getMinZ() >> 4;
        int chunkMaxZ = selection.getMaxZ() >> 4;
        List pmf = distribution.getPmf();
        ArrayList<CompletableFuture<Void>> chunkTasks = new ArrayList<CompletableFuture<Void>>();
        for (int chunkX = chunkMinX; chunkX <= chunkMaxX; ++chunkX) {
            int minX = Math.max(selection.getMinX(), chunkX << 4);
            int maxX = Math.min(selection.getMaxX(), (chunkX << 4) + 15);
            for (int chunkZ = chunkMinZ; chunkZ <= chunkMaxZ; ++chunkZ) {
                int minZ = Math.max(selection.getMinZ(), chunkZ << 4);
                int maxZ = Math.min(selection.getMaxZ(), (chunkZ << 4) + 15);
                Chunk levelChunk = this.level.d(chunkX, chunkZ);
                ArrayList<CompletableFuture<Void>> chunkFutures = new ArrayList<CompletableFuture<Void>>();
                int lastSectionIndex = -1;
                for (int y = selection.getMinY(); y <= selection.getMaxY(); ++y) {
                    int sectionIndex = levelChunk.e(y);
                    if (lastSectionIndex == sectionIndex) continue;
                    lastSectionIndex = sectionIndex;
                    ChunkSection section = levelChunk.b(sectionIndex);
                    ChunkSection newSection = this.copy(section);
                    CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                        EnumeratedDistribution newDistribution = new EnumeratedDistribution(pmf);
                        for (int i = selection.getMinY(); i <= selection.getMaxY(); ++i) {
                            int m = levelChunk.e(i);
                            if (m < sectionIndex) continue;
                            if (m > sectionIndex) break;
                            for (int x = minX; x <= maxX; ++x) {
                                for (int z = minZ; z <= maxZ; ++z) {
                                    CraftBlockData type = (CraftBlockData)newDistribution.sample();
                                    int j = x & 0xF;
                                    int k = i & 0xF;
                                    int l = z & 0xF;
                                    IBlockData state = type.getState();
                                    blockCount.incrementAndGet();
                                    newSection.a(j, k, l, state, true);
                                    this.updateHeightMap((IChunkAccess)levelChunk, j, i, l, state);
                                }
                            }
                        }
                        try {
                            MinecraftServer.getServer().f(() -> {
                                levelChunk.d()[sectionIndex] = newSection;
                            }).get();
                        }
                        catch (InterruptedException | ExecutionException e2) {
                            throw new RuntimeException(e2);
                        }
                    }, parallelExecutor);
                    chunkFutures.add(future);
                }
                CompletableFuture<Void> thisChunk = CompletableFuture.allOf(chunkFutures.toArray(new CompletableFuture[0]));
                thisChunk.thenAccept(ignored -> MinecraftServer.getServer().f(() -> {
                    LightEngineThreaded lightEngine = this.level.L.a();
                    lightEngine.relight((Set)Sets.newHashSet((Object[])new ChunkCoordIntPair[]{levelChunk.f()}), c2 -> {}, c2 -> {});
                    this.sendUpdatePacket(levelChunk);
                }));
                chunkTasks.add(thisChunk);
            }
        }
        CompletableFuture<Void> future = CompletableFuture.allOf(chunkTasks.toArray(new CompletableFuture[0]));
        future.thenAccept(ignored -> consumer.accept(blockCount.get()));
    }

    private void sendUpdatePacket(@NotNull Chunk chunk) {
        PlayerChunk playerChunk = this.level.k().a.b(chunk.f().longKey);
        if (playerChunk == null) {
            return;
        }
        List playersInRange = playerChunk.y.a(playerChunk.i(), false);
        ClientboundLevelChunkWithLightPacket lightPacket = new ClientboundLevelChunkWithLightPacket(chunk, this.level.l_(), null, null, false);
        executor.execute(() -> {
            int size = playersInRange.size();
            for (int i = 0; i < size; ++i) {
                EntityPlayer player = (EntityPlayer)playersInRange.get(i);
                player.b.a((Packet)lightPacket);
            }
        });
    }

    private void updateHeightMap(IChunkAccess chunk, int x, int y, int z, IBlockData blockState) {
        ((HeightMap)chunk.g.get(HeightMap.Type.e)).a(x, y, z, blockState);
        ((HeightMap)chunk.g.get(HeightMap.Type.f)).a(x, y, z, blockState);
        ((HeightMap)chunk.g.get(HeightMap.Type.d)).a(x, y, z, blockState);
        ((HeightMap)chunk.g.get(HeightMap.Type.b)).a(x, y, z, blockState);
    }

    static {
        for (Field field : ChunkSection.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            FastFieldAccessor fieldAccessor = FastFieldAccessor.forField(field);
            accessors.add(fieldAccessor);
        }
        storage.setAccessible(true);
    }
}

