/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.nms;

import com.artillexstudios.axgraves.libs.axapi.nms.NMSHandler;
import com.artillexstudios.axgraves.libs.axapi.utils.LogUtils;
import com.artillexstudios.axgraves.libs.axapi.utils.Version;
import org.bukkit.plugin.java.JavaPlugin;

public class NMSHandlers {
    private static NMSHandler nmsHandler;

    private static boolean init(JavaPlugin plugin) {
        Version version = Version.getServerVersion();
        if (version == Version.UNKNOWN) {
            LogUtils.warn("Could not load plugin {} due to version mismatch! Found protocol version {} which is unsupported!", plugin.getName(), Version.protocolVersion());
            return false;
        }
        if (nmsHandler != null) {
            LogUtils.warn("NMS support has already been enabled!", new Object[0]);
            return false;
        }
        try {
            nmsHandler = (NMSHandler)Class.forName("com.artillexstudios.axgraves.libs.axapi.nms.%s.NMSHandler".formatted(version.nmsVersion)).getConstructor(JavaPlugin.class).newInstance(plugin);
        }
        catch (Exception exception) {
            LogUtils.warn("Could not enable NMSHandler due to an internal exception while loading NMSHandler!", exception);
            return false;
        }
        return true;
    }

    public static NMSHandler getNmsHandler() {
        return nmsHandler;
    }

    public static class American {
        public static boolean initialize(JavaPlugin plugin) {
            return NMSHandlers.init(plugin);
        }
    }

    public static class British {
        public static boolean initialise(JavaPlugin plugin) {
            return NMSHandlers.init(plugin);
        }
    }
}

