/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.hologram;

import com.artillexstudios.axgraves.libs.axapi.collections.ThreadSafeList;
import com.artillexstudios.axgraves.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axgraves.libs.axapi.hologram.HologramLine;
import com.artillexstudios.axgraves.libs.axapi.hologram.HologramPage;
import com.artillexstudios.axgraves.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axgraves.libs.axapi.utils.Pair;
import com.artillexstudios.axgraves.libs.axapi.utils.placeholder.Placeholder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Hologram {
    private final WeakHashMap<Player, Integer> playerPages = new WeakHashMap();
    private final ObjectArrayList<Placeholder> placeholders = new ObjectArrayList(5);
    private final ThreadSafeList<HologramPage> pages = new ThreadSafeList();
    private final double lineSpace;
    private Consumer<PacketEntityInteractEvent> event;
    private Location location;
    private String id;

    public Hologram(Location location, String id) {
        this(location, id, 0.75);
    }

    public Hologram(Location location, String id, double lineSpace) {
        this.lineSpace = lineSpace;
        this.location = location;
        this.id = id;
        if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
            this.addPlaceholder(new Placeholder(PlaceholderAPI::setPlaceholders));
        }
    }

    public void teleport(Location location) {
        this.location = location;
        for (int i = 0; i < this.pages.size(); ++i) {
            HologramPage page = this.pages.get(i);
            page.realign();
        }
    }

    public void addLines(List<String> content, HologramLine.Type type) {
        for (String s : content) {
            this.addLine(s, type);
        }
    }

    public void addLine(String content, HologramLine.Type type) {
        HologramPage page = this.pages.isEmpty() ? this.newPage() : this.pages.get(0);
        page.addLine(content, type);
    }

    public void addLines(List<Pair<String, HologramLine.Type>> lines) {
        for (Pair<String, HologramLine.Type> line : lines) {
            this.addLine(line.first(), line.second());
        }
    }

    public void remove() {
        for (int i = 0; i < this.pages.size(); ++i) {
            HologramPage page = this.pages.get(i);
            page.remove();
        }
    }

    public void setLine(int pageIndex, int lineIndex, String content) {
        HologramPage page = this.pages.get(pageIndex);
        HologramLine line = page.getLine(lineIndex);
        line.setContent(content);
    }

    public void addPlaceholder(Placeholder placeholder) {
        this.placeholders.add((Object)placeholder);
        for (int i = 0; i < this.pages.size(); ++i) {
            HologramPage page = this.pages.get(i);
            page.addPlaceholder(placeholder);
        }
    }

    public ObjectArrayList<Placeholder> placeholders() {
        return this.placeholders;
    }

    public HologramPage newPage() {
        HologramPage page = new HologramPage(this);
        this.addPage(page);
        return page;
    }

    public void setLine(int lineIndex, String content) {
        this.setLine(0, lineIndex, content);
    }

    public void addPage(HologramPage page) {
        this.pages.add(page);
        for (int i = 0; i < this.placeholders.size(); ++i) {
            Placeholder placeholder = (Placeholder)this.placeholders.get(i);
            page.addPlaceholder(placeholder);
        }
    }

    public void removePage(HologramPage page) {
        this.pages.remove(page);
    }

    public HologramPage page(int pageIndex) {
        return this.pages.get(pageIndex);
    }

    public void changePage(Player player, PageChangeDirection direction) {
        if (this.pages.isEmpty() || this.pages.size() == 1) {
            return;
        }
        Integer page = this.playerPages.get(player);
        if (direction == PageChangeDirection.BACK) {
            int current;
            int n = current = page == null ? 0 : page;
            if (current - 1 < 0) {
                return;
            }
            HologramPage previousPage = this.pages.get(current);
            previousPage.hide(player);
            HologramPage newPage = this.pages.get(current - 1);
            newPage.show(player);
            this.playerPages.put(player, current - 1);
        } else {
            int current;
            int n = current = page == null ? 0 : page;
            if (current + 1 >= this.pages.size()) {
                return;
            }
            HologramPage previousPage = this.pages.get(current);
            previousPage.hide(player);
            HologramPage newPage = this.pages.get(current + 1);
            newPage.show(player);
            this.playerPages.put(player, current + 1);
        }
    }

    public void event(Consumer<PacketEntityInteractEvent> event) {
        this.event = event;
        for (int i = 0; i < this.pages.size(); ++i) {
            HologramPage page = this.pages.get(i);
            if (page.event() != null) continue;
            page.event(event);
        }
    }

    public Consumer<PacketEntityInteractEvent> event() {
        return this.event;
    }

    public double lineSpace() {
        return this.lineSpace;
    }

    public Location location() {
        return this.location;
    }

    public String id() {
        return this.id;
    }

    public static enum PageChangeDirection {
        BACK,
        FORWARD;

    }
}

