/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.grave;

import com.artillexstudios.axgraves.AxGraves;
import com.artillexstudios.axgraves.api.events.GraveInteractEvent;
import com.artillexstudios.axgraves.api.events.GraveOpenEvent;
import com.artillexstudios.axgraves.grave.SpawnedGraves;
import com.artillexstudios.axgraves.libs.axapi.hologram.Hologram;
import com.artillexstudios.axgraves.libs.axapi.hologram.HologramLine;
import com.artillexstudios.axgraves.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axgraves.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axgraves.libs.axapi.packetentity.PacketEntity;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.entity.ArmorStandMeta;
import com.artillexstudios.axgraves.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axgraves.libs.axapi.serializers.Serializers;
import com.artillexstudios.axgraves.libs.axapi.utils.EquipmentSlot;
import com.artillexstudios.axgraves.libs.axapi.utils.StringUtils;
import com.artillexstudios.axgraves.libs.axapi.utils.placeholder.Placeholder;
import com.artillexstudios.axgraves.libs.gui.builder.gui.StorageBuilder;
import com.artillexstudios.axgraves.libs.gui.guis.Gui;
import com.artillexstudios.axgraves.libs.gui.guis.StorageGui;
import com.artillexstudios.axgraves.libs.kyori.text.minimessage.tag.resolver.TagResolver;
import com.artillexstudios.axgraves.utils.BlacklistUtils;
import com.artillexstudios.axgraves.utils.ExperienceUtils;
import com.artillexstudios.axgraves.utils.InventoryUtils;
import com.artillexstudios.axgraves.utils.LocationUtils;
import com.artillexstudios.axgraves.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Grave {
    private static final Vector ZERO_VECTOR = new Vector(0, 0, 0);
    private final long spawned;
    private final Location location;
    private final OfflinePlayer player;
    private final String playerName;
    private final StorageGui gui;
    private int storedXP;
    private final PacketEntity entity;
    private final Hologram hologram;
    private boolean removed = false;

    public Grave(Location loc, @NotNull OfflinePlayer offlinePlayer, @NotNull ItemStack[] itemsAr, int storedXP, long date) {
        Player p;
        Player pl;
        this.location = LocationUtils.getCenterOf(loc, true);
        Player player = pl = offlinePlayer instanceof Player ? (p = (Player)offlinePlayer) : null;
        if (pl != null && AxGraves.MESSAGES.getBoolean("death-message.enabled", false)) {
            AxGraves.MESSAGEUTILS.sendLang((CommandSender)pl, "death-message.message", Map.of("%world%", this.location.getWorld().getName(), "%x%", "" + this.location.getBlockX(), "%y%", "" + this.location.getBlockY(), "%z%", "" + this.location.getBlockZ()));
        }
        if (this.location.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) || this.location.getWorld().getEnvironment().equals((Object)World.Environment.THE_END)) {
            this.location.setY(Math.max(this.location.getY(), (double)AxGraves.CONFIG.getDouble("spawn-height-limits." + this.location.getWorld().getName() + ".min", 0.0f)));
        } else {
            this.location.setY(Math.max(this.location.getY(), (double)AxGraves.CONFIG.getDouble("spawn-height-limits." + this.location.getWorld().getName() + ".min", -64.0f)));
        }
        this.location.setY(Math.min(this.location.getY(), (double)AxGraves.CONFIG.getDouble("spawn-height-limits." + this.location.getWorld().getName() + ".max", 319.0f)));
        this.player = offlinePlayer;
        this.playerName = offlinePlayer.getName() == null ? AxGraves.MESSAGES.getString("unknown-player", "???") : offlinePlayer.getName();
        ItemStack[] items = pl == null ? itemsAr : (ItemStack[])Arrays.stream(InventoryUtils.reorderInventory(pl.getInventory(), itemsAr)).filter(Objects::nonNull).toArray(ItemStack[]::new);
        this.gui = ((StorageBuilder)((StorageBuilder)Gui.storage().title(StringUtils.format(AxGraves.MESSAGES.getString("gui-name").replace("%player%", this.playerName), new TagResolver[0]))).rows(items.length % 9 == 0 ? items.length / 9 : 1 + items.length / 9)).create();
        this.storedXP = storedXP;
        this.spawned = date;
        for (ItemStack it : items) {
            if (it == null || BlacklistUtils.isBlacklisted(it)) continue;
            this.gui.addItem(it);
        }
        this.entity = NMSHandlers.getNmsHandler().createEntity(EntityType.ARMOR_STAND, this.location.clone().add(0.0, (double)(1.0f + AxGraves.CONFIG.getFloat("head-height", -1.2f)), 0.0));
        this.entity.setItem(EquipmentSlot.HELMET, WrappedItemStack.wrap(Utils.getPlayerHead(offlinePlayer)));
        ArmorStandMeta meta = (ArmorStandMeta)this.entity.meta();
        meta.small(true);
        meta.invisible(true);
        meta.setNoBasePlate(false);
        this.entity.spawn();
        if (AxGraves.CONFIG.getBoolean("rotate-head-360", true)) {
            this.entity.location().setYaw(this.location.getYaw());
            this.entity.teleport(this.entity.location());
        } else {
            this.entity.location().setYaw((float)LocationUtils.getNearestDirection(this.location.getYaw()));
            this.entity.teleport(this.entity.location());
        }
        this.entity.onInteract(event -> Scheduler.get().run(task -> this.interact(event.getPlayer(), event.getHand())));
        this.hologram = new Hologram(this.location.clone().add(0.0, (double)(1.0f + AxGraves.CONFIG.getFloat("hologram-height", 1.2f)), 0.0), Serializers.LOCATION.serialize(this.location), 0.3);
        int time = AxGraves.CONFIG.getInt("despawn-time-seconds", 180);
        this.hologram.addPlaceholder(new Placeholder((player1, string) -> {
            string = string.replace("%player%", this.playerName);
            string = string.replace("%xp%", "" + storedXP);
            string = string.replace("%item%", "" + this.countItems());
            string = string.replace("%despawn-time%", StringUtils.formatTime(time != -1 ? (long)time * 1000L - (System.currentTimeMillis() - this.spawned) : System.currentTimeMillis() - this.spawned));
            return string;
        }));
        int ms = AxGraves.MESSAGES.getStringList("hologram").size();
        for (int i = 0; i < ms; ++i) {
            this.hologram.addLine(StringUtils.formatToString(AxGraves.MESSAGES.getStringList("hologram").get(i), new TagResolver[0]), HologramLine.Type.TEXT);
        }
    }

    public void update() {
        boolean empty;
        int items = this.countItems();
        int time = AxGraves.CONFIG.getInt("despawn-time-seconds", 180);
        boolean outOfTime = (long)time * 1000L <= System.currentTimeMillis() - this.spawned;
        boolean despawn = AxGraves.CONFIG.getBoolean("despawn-when-empty", true);
        boolean bl = empty = items == 0 && this.storedXP == 0;
        if (time != -1 && outOfTime || despawn && empty) {
            Scheduler.get().runAt(this.location, this::remove);
            return;
        }
        if (AxGraves.CONFIG.getBoolean("auto-rotation.enabled", false)) {
            this.entity.location().setYaw(this.entity.location().getYaw() + AxGraves.CONFIG.getFloat("auto-rotation.speed", 10.0f));
            this.entity.teleport(this.entity.location());
        }
    }

    public void interact(@NotNull Player opener, org.bukkit.inventory.EquipmentSlot slot) {
        if (AxGraves.CONFIG.getBoolean("interact-only-own", false) && !opener.getUniqueId().equals(this.player.getUniqueId()) && !opener.hasPermission("axgraves.admin")) {
            AxGraves.MESSAGEUTILS.sendLang((CommandSender)opener, "interact.not-your-grave", new TagResolver[0]);
            return;
        }
        GraveInteractEvent graveInteractEvent = new GraveInteractEvent(opener, this);
        Bukkit.getPluginManager().callEvent((Event)graveInteractEvent);
        if (graveInteractEvent.isCancelled()) {
            return;
        }
        if (this.storedXP != 0) {
            ExperienceUtils.changeExp(opener, this.storedXP);
            this.storedXP = 0;
        }
        if (slot.equals((Object)org.bukkit.inventory.EquipmentSlot.HAND) && opener.isSneaking()) {
            if (opener.getGameMode() == GameMode.SPECTATOR) {
                return;
            }
            if (!AxGraves.CONFIG.getBoolean("enable-instant-pickup", true)) {
                return;
            }
            if (AxGraves.CONFIG.getBoolean("instant-pickup-only-own", false) && !opener.getUniqueId().equals(this.player.getUniqueId())) {
                return;
            }
            for (ItemStack it : this.gui.getInventory().getContents()) {
                Collection ar;
                if (it == null) continue;
                if (AxGraves.CONFIG.getBoolean("auto-equip-armor", true)) {
                    if (it.getType().toString().endsWith("_HELMET") && opener.getInventory().getHelmet() == null) {
                        opener.getInventory().setHelmet(it);
                        it.setAmount(0);
                        continue;
                    }
                    if (it.getType().toString().endsWith("_CHESTPLATE") && opener.getInventory().getChestplate() == null) {
                        opener.getInventory().setChestplate(it);
                        it.setAmount(0);
                        continue;
                    }
                    if (it.getType().toString().endsWith("_LEGGINGS") && opener.getInventory().getLeggings() == null) {
                        opener.getInventory().setLeggings(it);
                        it.setAmount(0);
                        continue;
                    }
                    if (it.getType().toString().endsWith("_BOOTS") && opener.getInventory().getBoots() == null) {
                        opener.getInventory().setBoots(it);
                        it.setAmount(0);
                        continue;
                    }
                }
                if ((ar = opener.getInventory().addItem(new ItemStack[]{it}).values()).isEmpty()) {
                    it.setAmount(0);
                    continue;
                }
                it.setAmount(((ItemStack)ar.iterator().next()).getAmount());
            }
            this.update();
            return;
        }
        GraveOpenEvent graveOpenEvent = new GraveOpenEvent(opener, this);
        Bukkit.getPluginManager().callEvent((Event)graveOpenEvent);
        if (graveOpenEvent.isCancelled()) {
            return;
        }
        this.gui.open((HumanEntity)opener);
    }

    public void reload() {
        int ms = AxGraves.MESSAGES.getStringList("hologram").size();
        for (int i = 0; i < ms; ++i) {
            String msg = AxGraves.MESSAGES.getStringList("hologram").get(i);
            if (i > this.hologram.page(0).lines().size() - 1) {
                this.hologram.addLine(StringUtils.formatToString(msg, new TagResolver[0]), HologramLine.Type.TEXT);
                continue;
            }
            this.hologram.setLine(i, StringUtils.formatToString(msg, new TagResolver[0]));
        }
    }

    public int countItems() {
        int am = 0;
        for (ItemStack it : this.gui.getInventory().getContents()) {
            if (it == null) continue;
            ++am;
        }
        return am;
    }

    public void remove() {
        if (this.removed) {
            return;
        }
        this.removed = true;
        if (Bukkit.isPrimaryThread()) {
            this.removeNow();
            return;
        }
        Scheduler.get().runAt(this.location, scheduledTask -> this.removeNow());
    }

    private void removeNow() {
        SpawnedGraves.removeGrave(this);
        this.removeInventory();
        if (this.entity != null) {
            this.entity.remove();
        }
        if (this.hologram != null) {
            this.hologram.remove();
        }
    }

    public void removeInventory() {
        this.closeInventory();
        if (AxGraves.CONFIG.getBoolean("drop-items", true)) {
            for (ItemStack it : this.gui.getInventory().getContents()) {
                if (it == null) continue;
                Item item = this.location.getWorld().dropItem(this.location.clone(), it);
                if (AxGraves.CONFIG.getBoolean("dropped-item-velocity", true)) continue;
                item.setVelocity(ZERO_VECTOR);
            }
        }
        if (this.storedXP == 0) {
            return;
        }
        ExperienceOrb exp = (ExperienceOrb)this.location.getWorld().spawnEntity(this.location, EntityType.EXPERIENCE_ORB);
        exp.setExperience(this.storedXP);
    }

    private void closeInventory() {
        ArrayList viewers = new ArrayList(this.gui.getInventory().getViewers());
        for (HumanEntity viewer : viewers) {
            viewer.closeInventory();
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public OfflinePlayer getPlayer() {
        return this.player;
    }

    public long getSpawned() {
        return this.spawned;
    }

    public StorageGui getGui() {
        return this.gui;
    }

    public int getStoredXP() {
        return this.storedXP;
    }

    public PacketEntity getEntity() {
        return this.entity;
    }

    public Hologram getHologram() {
        return this.hologram;
    }

    public String getPlayerName() {
        return this.playerName;
    }
}

