/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.ore.ores;

import com.dfsek.terra.addons.ore.lib.jafama.FastMath;
import com.dfsek.terra.api.block.BlockType;
import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.structure.Structure;
import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.collection.MaterialSet;
import com.dfsek.terra.api.util.vector.Vector3Int;
import com.dfsek.terra.api.world.WritableWorld;
import java.util.Map;
import java.util.Random;

public class VanillaOre
implements Structure {
    private final BlockState material;
    private final double size;
    private final MaterialSet replaceable;
    private final boolean applyGravity;
    private final double exposed;
    private final Map<BlockType, BlockState> materials;

    public VanillaOre(BlockState material, double size, MaterialSet replaceable, boolean applyGravity, double exposed, Map<BlockType, BlockState> materials) {
        this.material = material;
        this.size = size;
        this.replaceable = replaceable;
        this.applyGravity = applyGravity;
        this.exposed = exposed;
        this.materials = materials;
    }

    public boolean generate(Vector3Int location, WritableWorld world, Random random, Rotation rotation) {
        int centerX = location.getX();
        int centerZ = location.getZ();
        int centerY = location.getY();
        float f = random.nextFloat() * (float)Math.PI;
        double d1 = (double)(centerX + 8) + FastMath.sin(f) * this.size / 8.0;
        double d2 = (double)(centerX + 8) - FastMath.sin(f) * this.size / 8.0;
        double d3 = (double)(centerZ + 8) + FastMath.cos(f) * this.size / 8.0;
        double d4 = (double)(centerZ + 8) - FastMath.cos(f) * this.size / 8.0;
        double d5 = (double)(centerY + random.nextInt(3)) - 2.0;
        double d6 = (double)(centerY + random.nextInt(3)) - 2.0;
        int i = 0;
        while ((double)i < this.size) {
            float iFactor = (float)i / (float)this.size;
            double d10 = random.nextDouble() * this.size / 16.0;
            double d11 = (FastMath.sin(Math.PI * (double)iFactor) + 1.0) * d10 + 1.0;
            double d12 = (FastMath.sin(Math.PI * (double)iFactor) + 1.0) * d10 + 1.0;
            int xStart = FastMath.roundToInt(FastMath.floor(d1 + (d2 - d1) * (double)iFactor - d11 / 2.0));
            int yStart = FastMath.roundToInt(FastMath.floor(d5 + (d6 - d5) * (double)iFactor - d12 / 2.0));
            int zStart = FastMath.roundToInt(FastMath.floor(d3 + (d4 - d3) * (double)iFactor - d11 / 2.0));
            int xEnd = FastMath.roundToInt(FastMath.floor(d1 + (d2 - d1) * (double)iFactor + d11 / 2.0));
            int yEnd = FastMath.roundToInt(FastMath.floor(d5 + (d6 - d5) * (double)iFactor + d12 / 2.0));
            int zEnd = FastMath.roundToInt(FastMath.floor(d3 + (d4 - d3) * (double)iFactor + d11 / 2.0));
            for (int x = xStart; x <= xEnd; ++x) {
                double d13 = ((double)x + 0.5 - (d1 + (d2 - d1) * (double)iFactor)) / (d11 / 2.0);
                if (!(d13 * d13 < 1.0)) continue;
                for (int y = yStart; y <= yEnd; ++y) {
                    double d14 = ((double)y + 0.5 - (d5 + (d6 - d5) * (double)iFactor)) / (d12 / 2.0);
                    if (!(d13 * d13 + d14 * d14 < 1.0)) continue;
                    for (int z = zStart; z <= zEnd; ++z) {
                        double d15 = ((double)z + 0.5 - (d3 + (d4 - d3) * (double)iFactor)) / (d11 / 2.0);
                        if (y >= world.getMaxHeight() || y < world.getMinHeight()) continue;
                        BlockType block = world.getBlockState(x, y, z).getBlockType();
                        if (!(d13 * d13 + d14 * d14 + d15 * d15 < 1.0) || !this.getReplaceable().contains((Object)block) || !(this.exposed > random.nextDouble()) && (world.getBlockState(x, y, z - 1).isAir() || world.getBlockState(x, y, z + 1).isAir() || world.getBlockState(x, y - 1, z).isAir() || world.getBlockState(x, y + 1, z).isAir() || world.getBlockState(x - 1, y, z).isAir() || world.getBlockState(x + 1, y, z).isAir())) continue;
                        world.setBlockState(x, y, z, this.getMaterial(block), this.isApplyGravity());
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public BlockState getMaterial(BlockType replace) {
        return this.materials.getOrDefault(replace, this.material);
    }

    public MaterialSet getReplaceable() {
        return this.replaceable;
    }

    public boolean isApplyGravity() {
        return this.applyGravity;
    }
}

