/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftRegistryAccess;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.ClonableWrapper;
import com.comphenix.protocol.wrappers.ComponentParser;
import com.comphenix.protocol.wrappers.codecs.WrappedCodec;
import com.comphenix.protocol.wrappers.codecs.WrappedDynamicOps;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Optional;

public class WrappedChatComponent
extends AbstractWrapper
implements ClonableWrapper {
    private static final Class<?> SERIALIZER = MinecraftReflection.getChatSerializerClass();
    private static final Class<?> COMPONENT = MinecraftReflection.getIChatBaseComponentClass();
    private static final Class<?> GSON_CLASS = MinecraftReflection.getMinecraftGsonClass();
    private static final Optional<Class<?>> MUTABLE_COMPONENT_CLASS = MinecraftReflection.getOptionalNMS("network.chat.IChatMutableComponent", new String[0]);
    private static Object GSON = null;
    private static MethodAccessor DESERIALIZE = null;
    private static MethodAccessor SERIALIZE_COMPONENT = null;
    private static MethodAccessor CONSTRUCT_COMPONENT = null;
    private static ConstructorAccessor CONSTRUCT_TEXT_COMPONENT = null;
    private static WrappedCodec CODEC;
    private transient String cache;

    private static Object serialize(Object handle) {
        if (CODEC != null) {
            Object jobj = CODEC.encode(handle, WrappedDynamicOps.json(false)).getOrThrow(JsonParseException::new);
            return jobj.toString();
        }
        if (MinecraftVersion.v1_20_5.atOrAbove()) {
            return SERIALIZE_COMPONENT.invoke(null, handle, MinecraftRegistryAccess.get());
        }
        return SERIALIZE_COMPONENT.invoke(null, handle);
    }

    private static Object deserialize(String json) {
        if (CODEC != null) {
            return CODEC.parse(JsonParser.parseString((String)json), WrappedDynamicOps.json(false)).getOrThrow(JsonParseException::new);
        }
        if (MinecraftVersion.v1_20_5.atOrAbove()) {
            return DESERIALIZE.invoke(null, json, MinecraftRegistryAccess.get());
        }
        if (MinecraftVersion.v1_20_4.atOrAbove()) {
            return DESERIALIZE.invoke(null, json);
        }
        if (DESERIALIZE != null) {
            return DESERIALIZE.invoke(null, GSON, json, COMPONENT, true);
        }
        StringReader str = new StringReader(json);
        return ComponentParser.deserialize(GSON, COMPONENT, str);
    }

    private WrappedChatComponent(Object handle, String cache) {
        super(MinecraftReflection.getIChatBaseComponentClass());
        this.setHandle(handle);
        this.cache = cache;
    }

    public static WrappedChatComponent fromHandle(Object handle) {
        return new WrappedChatComponent(handle, null);
    }

    public static WrappedChatComponent fromJson(String json) {
        return new WrappedChatComponent(WrappedChatComponent.deserialize(json), json);
    }

    public static WrappedChatComponent fromText(String text) {
        Preconditions.checkNotNull((Object)text, (Object)"text cannot be NULL.");
        if (CONSTRUCT_TEXT_COMPONENT != null) {
            return WrappedChatComponent.fromHandle(CONSTRUCT_TEXT_COMPONENT.invoke(text));
        }
        JsonObject object = new JsonObject();
        object.addProperty("text", text);
        return WrappedChatComponent.fromJson(object.toString());
    }

    public static WrappedChatComponent[] fromChatMessage(String message) {
        Object[] components = (Object[])CONSTRUCT_COMPONENT.invoke(null, message, false);
        WrappedChatComponent[] result = new WrappedChatComponent[components.length];
        for (int i = 0; i < components.length; ++i) {
            result[i] = WrappedChatComponent.fromHandle(components[i]);
        }
        return result;
    }

    public static WrappedChatComponent fromLegacyText(String message) {
        Object[] components = (Object[])CONSTRUCT_COMPONENT.invoke(null, message, true);
        return WrappedChatComponent.fromHandle(components[0]);
    }

    public String getJson() {
        if (this.cache == null) {
            this.cache = (String)WrappedChatComponent.serialize(this.handle);
        }
        return this.cache;
    }

    public void setJson(String obj) {
        this.handle = WrappedChatComponent.deserialize(obj);
        this.cache = obj;
    }

    @Override
    public WrappedChatComponent deepClone() {
        return WrappedChatComponent.fromJson(this.getJson());
    }

    @Override
    public String toString() {
        return "WrappedChatComponent[json=" + this.getJson() + "]";
    }

    static {
        FuzzyReflection fuzzy = FuzzyReflection.fromClass(SERIALIZER, true);
        if (MinecraftVersion.v1_21_6.atOrAbove()) {
            Field codecField = fuzzy.getFieldByType("CODEC", MinecraftReflection.getCodecClass());
            CODEC = WrappedCodec.fromHandle(Accessors.getFieldAccessor(codecField).get(null));
        } else {
            SERIALIZE_COMPONENT = MinecraftVersion.v1_20_5.atOrAbove() ? Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().returnTypeExact(String.class).parameterDerivedOf(COMPONENT).parameterDerivedOf(MinecraftReflection.getHolderLookupProviderClass()).build())) : Accessors.getMethodAccessor(fuzzy.getMethodByReturnTypeAndParameters("serialize", String.class, COMPONENT));
        }
        if (!MinecraftVersion.v1_20_4.atOrAbove()) {
            GSON = Accessors.getFieldAccessor(fuzzy.getFieldByType("gson", GSON_CLASS)).get(null);
        }
        if (!MinecraftVersion.v1_21_6.atOrAbove()) {
            if (MinecraftVersion.v1_20_5.atOrAbove()) {
                DESERIALIZE = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().returnDerivedOf(COMPONENT).parameterExactType(String.class).parameterDerivedOf(MinecraftReflection.getHolderLookupProviderClass()).build()));
            } else if (MinecraftVersion.v1_20_4.atOrAbove()) {
                DESERIALIZE = Accessors.getMethodAccessor(fuzzy.getMethodByReturnTypeAndParameters("fromJson", MUTABLE_COMPONENT_CLASS.get(), String.class));
            } else {
                try {
                    DESERIALIZE = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getChatDeserializer(), true).getMethodByReturnTypeAndParameters("deserialize", Object.class, GSON_CLASS, String.class, Class.class, Boolean.TYPE));
                }
                catch (IllegalArgumentException ex) {
                    DESERIALIZE = null;
                }
            }
        }
        CONSTRUCT_COMPONENT = Accessors.getMethodAccessor(MinecraftReflection.getCraftChatMessage(), "fromString", String.class, Boolean.TYPE);
        try {
            CONSTRUCT_TEXT_COMPONENT = Accessors.getConstructorAccessor(MinecraftReflection.getChatComponentTextClass(), String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

