/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.timing;

import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.timing.PluginTimingTracker;
import com.comphenix.protocol.timing.TimingListenerType;
import com.comphenix.protocol.timing.TimingReport;
import com.comphenix.protocol.timing.TimingTracker;
import com.google.common.collect.ImmutableMap;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class TimingTrackerManager {
    private static final AtomicBoolean IS_TRACKING = new AtomicBoolean();
    private static volatile Date startTime;
    private static volatile Date stopTime;
    private static final Map<String, ImmutableMap<TimingListenerType, PluginTimingTracker>> TRACKER_MAP;

    public static boolean startTracking() {
        if (IS_TRACKING.compareAndSet(false, true)) {
            startTime = Calendar.getInstance().getTime();
            return true;
        }
        return false;
    }

    public static boolean isTracking() {
        return IS_TRACKING.get();
    }

    public static boolean stopTracking() {
        if (IS_TRACKING.compareAndSet(true, false)) {
            stopTime = Calendar.getInstance().getTime();
            return true;
        }
        return false;
    }

    public static TimingReport createReportAndReset() {
        TimingReport report = new TimingReport(startTime, stopTime, (ImmutableMap<String, ImmutableMap<TimingListenerType, PluginTimingTracker>>)ImmutableMap.copyOf(TRACKER_MAP));
        TRACKER_MAP.clear();
        return report;
    }

    public static TimingTracker get(PacketListener listener, TimingListenerType type) {
        if (!IS_TRACKING.get()) {
            return TimingTracker.EMPTY;
        }
        String plugin = listener.getPlugin().getName();
        return (TimingTracker)TRACKER_MAP.computeIfAbsent(plugin, k -> TimingTrackerManager.newTrackerMap()).get((Object)type);
    }

    private static ImmutableMap<TimingListenerType, PluginTimingTracker> newTrackerMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TimingListenerType type : TimingListenerType.values()) {
            builder.put((Object)type, (Object)new PluginTimingTracker());
        }
        return builder.build();
    }

    static {
        TRACKER_MAP = new ConcurrentHashMap<String, ImmutableMap<TimingListenerType, PluginTimingTracker>>();
    }
}

