/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.timing;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.timing.StatisticsStream;
import com.comphenix.protocol.timing.TimingTracker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginTimingTracker
implements TimingTracker {
    private final Map<PacketType, StatisticsStream> statistics = new ConcurrentHashMap<PacketType, StatisticsStream>();
    private volatile boolean hasReceivedData = false;

    @Override
    public void track(PacketType packetType, Runnable runnable) {
        long startTime = System.nanoTime();
        runnable.run();
        long endTime = System.nanoTime();
        this.statistics.computeIfAbsent(packetType, key -> new StatisticsStream()).observe(endTime - startTime);
        this.hasReceivedData = true;
    }

    public boolean hasReceivedData() {
        return this.hasReceivedData;
    }

    public Map<PacketType, StatisticsStream> getStatistics() {
        return this.statistics;
    }
}

