/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.instances;

import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;

public final class InstanceCreator
implements Supplier<Object> {
    private static Map<Class<?>, Object> BANNED_PARAMETERS = new WeakHashMap();
    private ConstructorAccessor constructor = null;
    private MethodAccessor factoryMethod = null;
    private Class<?>[] paramTypes = null;
    private boolean failed = false;
    private final Class<?> type;

    private InstanceCreator(Class<?> type) {
        this.type = type;
    }

    public static InstanceCreator forClass(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        return new InstanceCreator(type);
    }

    private Object createInstance(Class<?> clazz) {
        try {
            return DefaultInstances.DEFAULT.create(clazz);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private Object[] createParams(Class<?>[] paramTypes) {
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            params[i] = this.createInstance(paramTypes[i]);
        }
        return params;
    }

    private boolean containsBannedParameter(Class<?>[] paramTypes) {
        for (Class<?> paramType : paramTypes) {
            if (!BANNED_PARAMETERS.containsKey(paramType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get() {
        Object[] params;
        Object[] objectArray = params = this.paramTypes != null ? this.createParams(this.paramTypes) : null;
        if (this.constructor != null) {
            return this.constructor.invoke(params);
        }
        if (this.factoryMethod != null) {
            return this.factoryMethod.invoke(null, params);
        }
        if (this.failed) {
            return null;
        }
        Object result = null;
        int minCount = Integer.MAX_VALUE;
        for (Constructor<?> constructor : this.type.getDeclaredConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length > minCount || this.containsBannedParameter(paramTypes)) continue;
            Object[] testParams = this.createParams(paramTypes);
            try {
                ConstructorAccessor testAccessor = Accessors.getConstructorAccessor(constructor);
                result = testAccessor.invoke(testParams);
                minCount = paramTypes.length;
                this.constructor = testAccessor;
                this.paramTypes = paramTypes;
            }
            catch (Exception testAccessor) {
                // empty catch block
            }
        }
        if (result != null) {
            return result;
        }
        minCount = Integer.MAX_VALUE;
        for (Executable executable : this.type.getDeclaredMethods()) {
            Class<?>[] paramTypes;
            int modifiers = ((Method)executable).getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || ((Method)executable).getReturnType() != this.type || (paramTypes = ((Method)executable).getParameterTypes()).length > minCount || this.containsBannedParameter(paramTypes)) continue;
            Object[] testParams = this.createParams(paramTypes);
            try {
                MethodAccessor testAccessor = Accessors.getMethodAccessor((Method)executable);
                result = testAccessor.invoke(null, testParams);
                minCount = paramTypes.length;
                this.factoryMethod = testAccessor;
                this.paramTypes = paramTypes;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            this.failed = true;
        }
        return result;
    }

    static {
        try {
            BANNED_PARAMETERS.put(ByteBuffer.class, true);
            BANNED_PARAMETERS.put(FloatBuffer.class, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

