/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.fuzzy;

import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.ClassRegexMatcher;
import com.comphenix.protocol.reflect.fuzzy.ClassSetMatcher;
import com.comphenix.protocol.reflect.fuzzy.ClassTypeMatcher;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.regex.Pattern;

public class FuzzyMatchers {
    private static final AbstractFuzzyMatcher<Class<?>> MATCH_ALL = (value, parent) -> true;

    private FuzzyMatchers() {
    }

    public static AbstractFuzzyMatcher<Class<?>> matchArray(AbstractFuzzyMatcher<Class<?>> componentMatcher) {
        return (value, parent) -> value.isArray() && componentMatcher.isMatch(value.getComponentType(), parent);
    }

    public static AbstractFuzzyMatcher<Class<?>> except(Class<?> clazz) {
        return (value, parent) -> !clazz.isAssignableFrom((Class<?>)value);
    }

    public static AbstractFuzzyMatcher<Class<?>> assignable(Class<?> clazz) {
        return (value, parent) -> clazz.isAssignableFrom((Class<?>)value);
    }

    @SafeVarargs
    public static AbstractFuzzyMatcher<Class<?>> and(AbstractFuzzyMatcher<Class<?>> ... matchers) {
        return (value, parent) -> {
            for (AbstractFuzzyMatcher matcher : matchers) {
                if (matcher.isMatch(value, parent)) continue;
                return false;
            }
            return true;
        };
    }

    public static AbstractFuzzyMatcher<Class<?>> matchAll() {
        return MATCH_ALL;
    }

    public static AbstractFuzzyMatcher<Class<?>> matchExact(Class<?> matcher) {
        return new ClassTypeMatcher(matcher, ClassTypeMatcher.MatchVariant.MATCH_EXACT);
    }

    public static AbstractFuzzyMatcher<Class<?>> matchAnyOf(Class<?> ... classes) {
        return FuzzyMatchers.matchAnyOf(Sets.newHashSet((Object[])classes));
    }

    public static AbstractFuzzyMatcher<Class<?>> matchAnyOf(Set<Class<?>> classes) {
        return new ClassSetMatcher(classes);
    }

    public static AbstractFuzzyMatcher<Class<?>> matchSuper(Class<?> matcher) {
        return new ClassTypeMatcher(matcher, ClassTypeMatcher.MatchVariant.MATCH_SUPER);
    }

    public static AbstractFuzzyMatcher<Class<?>> matchDerived(Class<?> matcher) {
        return new ClassTypeMatcher(matcher, ClassTypeMatcher.MatchVariant.MATCH_DERIVED);
    }

    public static AbstractFuzzyMatcher<Class<?>> matchRegex(Pattern regex) {
        return new ClassRegexMatcher(regex);
    }

    public static AbstractFuzzyMatcher<Class<?>> matchRegex(String regex) {
        return FuzzyMatchers.matchRegex(Pattern.compile(regex));
    }

    static boolean checkPattern(Pattern a, Pattern b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        return a.pattern().equals(b.pattern());
    }
}

