/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.cloning;

import com.comphenix.protocol.reflect.cloning.Cloner;
import java.util.Optional;
import java.util.OptionalInt;

public class JavaOptionalCloner
implements Cloner {
    protected Cloner wrapped;

    public JavaOptionalCloner(Cloner wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public boolean canClone(Object source) {
        return source instanceof Optional || source instanceof OptionalInt;
    }

    @Override
    public Object clone(Object source) {
        if (source instanceof Optional) {
            Optional optional = (Optional)source;
            return optional.map(o -> this.wrapped.clone(o));
        }
        if (source instanceof OptionalInt) {
            OptionalInt optional = (OptionalInt)source;
            return optional.isPresent() ? OptionalInt.of(optional.getAsInt()) : OptionalInt.empty();
        }
        return null;
    }

    public Cloner getWrapped() {
        return this.wrapped;
    }
}

