/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect;

import com.comphenix.protocol.reflect.StructureModifier;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class ObjectWriter {
    private static final Map<Class<?>, StructureModifier<Object>> CACHE = new HashMap();

    private StructureModifier<Object> getModifier(Class<?> type) {
        StructureModifier value;
        StructureModifier<Object> modifier = CACHE.get(type);
        if (modifier == null && (modifier = CACHE.putIfAbsent(type, value = new StructureModifier(type, null, false))) == null) {
            modifier = value;
        }
        return modifier;
    }

    public void copyTo(Object source, Object destination, Class<?> commonType) {
        this.copyToInternal(source, destination, commonType, true);
    }

    protected void transformField(StructureModifier<Object> modifierSource, StructureModifier<Object> modifierDest, int fieldIndex) {
        Object value = modifierSource.read(fieldIndex);
        modifierDest.write(fieldIndex, value);
    }

    private void copyToInternal(Object source, Object destination, Class<?> commonType, boolean copyPublic) {
        StructureModifier<Object> modifier = this.getModifier(commonType);
        StructureModifier<Object> modifierSource = modifier.withTarget(source);
        StructureModifier<Object> modifierDest = modifier.withTarget(destination);
        try {
            for (int i = 0; i < modifierSource.size(); ++i) {
                Field field = modifierSource.getField(i);
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isPublic(mod) && !copyPublic) continue;
                this.transformField(modifierSource, modifierDest, i);
            }
            Class<?> superclass = commonType.getSuperclass();
            if (superclass != null && !superclass.equals(Object.class)) {
                this.copyToInternal(source, destination, superclass, false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to copy fields from " + commonType.getName(), e);
        }
    }
}

