/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.metrics;

import com.comphenix.protocol.ProtocolLib;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.metrics.Metrics;
import com.comphenix.protocol.utility.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;

public class Statistics {
    private Metrics metrics;

    public Statistics(ProtocolLib plugin) throws IOException {
        this.metrics = new Metrics(plugin);
        this.metrics.logFailedRequests(plugin.getProtocolConfig().isDebug());
        this.addCustomGraphs(this.metrics);
    }

    private void addCustomGraphs(Metrics metrics) {
        metrics.addCustomChart(new Metrics.AdvancedPie("pluginUsers", this::getPluginUsers));
        metrics.addCustomChart(new Metrics.SimplePie("buildVersion", this::getBuildNumber));
        metrics.addCustomChart(new Metrics.SimplePie("serverBrand", this::getServerBrand));
    }

    private String getServerBrand() {
        if (!Bukkit.getServer().getName().equals("CraftBukkit")) {
            return Bukkit.getServer().getName();
        }
        if (Util.isUsingSpigot()) {
            return "Spigot";
        }
        return "CraftBukkit";
    }

    private String getBuildNumber() {
        String version = ProtocolLibrary.getPlugin().getDescription().getVersion();
        if (version.contains("-b")) {
            String[] split = version.split("-b");
            return split[1];
        }
        if (!version.contains("SNAPSHOT")) {
            return "Release";
        }
        return "Unknown";
    }

    public static String getVersion() {
        String version = ProtocolLibrary.getPlugin().getDescription().getVersion();
        if (version.contains("-b")) {
            String[] split = version.split("-b");
            return split[0];
        }
        return version;
    }

    private Map<String, Integer> getPluginUsers() {
        HashMap<String, Integer> users = new HashMap<String, Integer>();
        for (PacketListener listener : ProtocolLibrary.getProtocolManager().getPacketListeners()) {
            String name = PacketAdapter.getPluginName(listener);
            users.put(name, 1);
        }
        return users;
    }
}

