/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.packet.internal;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.injector.packet.internal.IdCodecWrapper;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtocolInfoWrapper
extends AbstractWrapper {
    @NotNull
    private static final Class<?> SIMPLE_UNBOUND_PROTOCOL_CLASS = MinecraftReflection.getMinecraftClass("network.protocol.SimpleUnboundProtocol", "network.protocol.UnboundProtocol", "network.ProtocolInfo$a", "network.ProtocolInfo$Unbound");
    @NotNull
    private static final MethodAccessor BIND_SIMPLE_ACCESSOR = Accessors.getMethodAccessor(FuzzyReflection.fromClass(SIMPLE_UNBOUND_PROTOCOL_CLASS).getMethodByReturnTypeAndParameters("bind", MinecraftReflection.getProtocolInfoClass(), Function.class));
    @Nullable
    private static final Class<?> UNBOUND_PROTOCOL_CLASS = MinecraftReflection.getNullableNMS("network.protocol.UnboundProtocol", new String[0]);
    @Nullable
    private static final MethodAccessor BIND_CONTEXT_ACCESSOR = UNBOUND_PROTOCOL_CLASS != null ? Accessors.getMethodAccessor(FuzzyReflection.fromClass(UNBOUND_PROTOCOL_CLASS).getMethodByReturnTypeAndParameters("bind", MinecraftReflection.getProtocolInfoClass(), Function.class, Object.class)) : null;
    @NotNull
    private static final MethodAccessor ID_ACCESSOR;
    @NotNull
    private static final MethodAccessor FLOW_ACCESSOR;
    @NotNull
    private static final MethodAccessor CODEC_ACCESSOR;

    public static boolean isUnboundProtocol(Object protocol) {
        return SIMPLE_UNBOUND_PROTOCOL_CLASS.isInstance(protocol) || UNBOUND_PROTOCOL_CLASS != null && UNBOUND_PROTOCOL_CLASS.isInstance(protocol);
    }

    public static ProtocolInfoWrapper fromUnbound(Object protocol, Object context) {
        if (SIMPLE_UNBOUND_PROTOCOL_CLASS.isInstance(protocol)) {
            Object protocolInfo = BIND_SIMPLE_ACCESSOR.invoke(protocol, Function.identity());
            return new ProtocolInfoWrapper(protocolInfo);
        }
        if (UNBOUND_PROTOCOL_CLASS != null && UNBOUND_PROTOCOL_CLASS.isInstance(protocol)) {
            Object protocolInfo = BIND_CONTEXT_ACCESSOR.invoke(protocol, Function.identity(), Objects.requireNonNull(context));
            return new ProtocolInfoWrapper(protocolInfo);
        }
        throw new RuntimeException("Unknown protocol implementation: " + String.valueOf(protocol));
    }

    private ProtocolInfoWrapper(Object handle) {
        super(MinecraftReflection.getProtocolInfoClass());
        this.setHandle(handle);
    }

    public PacketType.Protocol id() {
        Object protocol = ID_ACCESSOR.invoke(this.handle, new Object[0]);
        return PacketType.Protocol.fromVanilla((Enum)protocol);
    }

    public PacketType.Sender flow() {
        String packetFlow = FLOW_ACCESSOR.invoke(this.handle, new Object[0]).toString();
        if (packetFlow.contains("CLIENTBOUND")) {
            return PacketType.Sender.SERVER;
        }
        if (packetFlow.contains("SERVERBOUND")) {
            return PacketType.Sender.CLIENT;
        }
        throw new RuntimeException("Unknown packet flow: " + packetFlow);
    }

    public IdCodecWrapper codec() {
        return new IdCodecWrapper(CODEC_ACCESSOR.invoke(this.handle, new Object[0]));
    }

    static {
        FuzzyReflection protocolInfoReflection = FuzzyReflection.fromClass(MinecraftReflection.getProtocolInfoClass());
        ID_ACCESSOR = Accessors.getMethodAccessor(protocolInfoReflection.getMethodByReturnTypeAndParameters("id", MinecraftReflection.getEnumProtocolClass(), new Class[0]));
        FLOW_ACCESSOR = Accessors.getMethodAccessor(protocolInfoReflection.getMethodByReturnTypeAndParameters("flow", MinecraftReflection.getPacketFlowClass(), new Class[0]));
        CODEC_ACCESSOR = Accessors.getMethodAccessor(protocolInfoReflection.getMethodByReturnTypeAndParameters("codec", MinecraftReflection.getStreamCodecClass(), new Class[0]));
    }
}

