/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.manager;

import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.injector.netty.channel.InjectionFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

final class InjectionChannelInboundHandler
extends ChannelInboundHandlerAdapter {
    private static final ReportType CANNOT_INJECT_CHANNEL = new ReportType("Unable to inject incoming channel %s.");
    private final ErrorReporter errorReporter;
    private final InjectionFactory injectionFactory;

    public InjectionChannelInboundHandler(ErrorReporter errorReporter, InjectionFactory injectionFactory) {
        this.errorReporter = errorReporter;
        this.injectionFactory = injectionFactory;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.fireChannelActive();
        if (!this.injectionFactory.isClosed()) {
            try {
                this.injectionFactory.fromChannel(ctx.channel()).inject();
            }
            catch (Exception exception) {
                this.errorReporter.reportDetailed((Object)this, Report.newBuilder(CANNOT_INJECT_CHANNEL).messageParam(ctx.channel()).error(exception).build());
            }
        }
        ctx.channel().pipeline().remove((ChannelHandler)this);
    }

    public boolean isSharable() {
        return true;
    }
}

