/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.collection;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.concurrent.PacketTypeListenerSet;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.collection.PacketListenerSet;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class OutboundPacketListenerSet
extends PacketListenerSet {
    public OutboundPacketListenerSet(PacketTypeListenerSet mainThreadPacketTypes, ErrorReporter errorReporter) {
        super(mainThreadPacketTypes, errorReporter);
    }

    @Override
    protected ListeningWhitelist getListeningWhitelist(PacketListener packetListener) {
        return packetListener.getSendingWhitelist();
    }

    @Override
    public void invoke(PacketEvent event, @Nullable ListenerPriority priorityFilter) {
        super.invoke(event, priorityFilter);
        if (event.getPacketType() == PacketType.Play.Server.BUNDLE && !event.isCancelled()) {
            Iterable<PacketContainer> packets = event.getPacket().getPacketBundles().read(0);
            ArrayList<PacketContainer> outPackets = new ArrayList<PacketContainer>();
            for (PacketContainer subPacket : packets) {
                PacketContainer packet;
                if (subPacket == null) continue;
                PacketEvent subPacketEvent = PacketEvent.fromServer(this, subPacket, event.getNetworkMarker(), event.getPlayer());
                super.invoke(subPacketEvent, priorityFilter);
                if (subPacketEvent.isCancelled() || (packet = subPacketEvent.getPacket()) == null || packet.getHandle() == null) continue;
                outPackets.add(packet);
            }
            if (packets.iterator().hasNext()) {
                event.getPacket().getPacketBundles().write(0, outPackets);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @Override
    protected void invokeListener(PacketEvent event, PacketListener listener) {
        try {
            event.setReadOnly(listener.getSendingWhitelist().getPriority() == ListenerPriority.MONITOR);
            listener.onPacketSending(event);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            this.errorReporter.reportMinimal(listener.getPlugin(), "onPacketSending(PacketEvent)", e, event.getPacket().getHandle());
        }
    }
}

