/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.ProtocolLib;
import com.comphenix.protocol.async.AsyncFilterManager;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.injector.InternalManager;
import com.comphenix.protocol.injector.PacketFilterManager;
import com.comphenix.protocol.utility.MinecraftVersion;
import javax.annotation.Nonnull;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class PacketFilterBuilder {
    private Server server;
    private ProtocolLib library;
    private MinecraftVersion mcVersion;
    private ErrorReporter reporter;
    private AsyncFilterManager asyncManager;

    public PacketFilterBuilder server(@Nonnull Server server) {
        this.server = server;
        return this;
    }

    public PacketFilterBuilder library(@Nonnull ProtocolLib library) {
        this.library = library;
        return this;
    }

    public PacketFilterBuilder minecraftVersion(@Nonnull MinecraftVersion mcVersion) {
        this.mcVersion = mcVersion;
        return this;
    }

    public PacketFilterBuilder reporter(@Nonnull ErrorReporter reporter) {
        this.reporter = reporter;
        return this;
    }

    public Server getServer() {
        return this.server;
    }

    public Plugin getLibrary() {
        return this.library;
    }

    public MinecraftVersion getMinecraftVersion() {
        return this.mcVersion;
    }

    public ErrorReporter getReporter() {
        return this.reporter;
    }

    public AsyncFilterManager getAsyncManager() {
        return this.asyncManager;
    }

    public InternalManager build() {
        if (this.reporter == null) {
            throw new IllegalArgumentException("reporter cannot be NULL.");
        }
        this.asyncManager = new AsyncFilterManager(this.reporter, this.library.getScheduler());
        return new PacketFilterManager(this);
    }
}

