/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import java.util.Collection;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;

public abstract class MonitorAdapter
implements PacketListener {
    private final Plugin plugin;
    private final ListeningWhitelist sending;
    private final ListeningWhitelist receiving;

    public MonitorAdapter(Plugin plugin, ConnectionSide side) {
        this.plugin = plugin;
        this.sending = side.isForServer() ? MonitorAdapter.buildWhitelist(PacketRegistry.getServerPacketTypes()) : ListeningWhitelist.EMPTY_WHITELIST;
        this.receiving = side.isForClient() ? MonitorAdapter.buildWhitelist(PacketRegistry.getClientPacketTypes()) : ListeningWhitelist.EMPTY_WHITELIST;
    }

    @Deprecated
    public MonitorAdapter(Plugin plugin, ConnectionSide side, Logger logger) {
        this(plugin, side);
    }

    private static ListeningWhitelist buildWhitelist(Collection<PacketType> packetTypes) {
        return ListeningWhitelist.newBuilder().monitor().gamePhaseBoth().types(packetTypes).build();
    }

    @Override
    public ListeningWhitelist getSendingWhitelist() {
        return this.sending;
    }

    @Override
    public ListeningWhitelist getReceivingWhitelist() {
        return this.receiving;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void onPacketSending(PacketEvent event) {
    }

    @Override
    public void onPacketReceiving(PacketEvent event) {
    }
}

