/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.async;

import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import org.bukkit.plugin.Plugin;

class NullPacketListener
implements PacketListener {
    private ListeningWhitelist sendingWhitelist;
    private ListeningWhitelist receivingWhitelist;
    private Plugin plugin;

    public NullPacketListener(PacketListener original) {
        this.sendingWhitelist = this.cloneWhitelist(ListenerPriority.LOW, original.getSendingWhitelist());
        this.receivingWhitelist = this.cloneWhitelist(ListenerPriority.LOW, original.getReceivingWhitelist());
        this.plugin = original.getPlugin();
    }

    @Override
    public void onPacketSending(PacketEvent event) {
    }

    @Override
    public void onPacketReceiving(PacketEvent event) {
    }

    @Override
    public ListeningWhitelist getSendingWhitelist() {
        return this.sendingWhitelist;
    }

    @Override
    public ListeningWhitelist getReceivingWhitelist() {
        return this.receivingWhitelist;
    }

    private ListeningWhitelist cloneWhitelist(ListenerPriority priority, ListeningWhitelist whitelist) {
        if (whitelist != null) {
            return ListeningWhitelist.newBuilder(whitelist).priority(priority).mergeOptions(ListenerOptions.ASYNC).build();
        }
        return null;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }
}

