/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.async;

import com.comphenix.protocol.AsynchronousManager;
import com.comphenix.protocol.PacketStream;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.async.AsyncListenerHandler;
import com.comphenix.protocol.async.AsyncMarker;
import com.comphenix.protocol.async.NullPacketListener;
import com.comphenix.protocol.async.PacketProcessingQueue;
import com.comphenix.protocol.async.PacketSendingQueue;
import com.comphenix.protocol.async.PlayerSendingHandler;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.collection.InboundPacketListenerSet;
import com.comphenix.protocol.injector.collection.OutboundPacketListenerSet;
import com.comphenix.protocol.scheduler.ProtocolScheduler;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AsyncFilterManager
implements AsynchronousManager {
    private OutboundPacketListenerSet outboundTimeoutListeners;
    private InboundPacketListenerSet inboundTimeoutListeners;
    private Set<PacketListener> timeoutListeners;
    private PacketProcessingQueue serverProcessingQueue;
    private PacketProcessingQueue clientProcessingQueue;
    private final PlayerSendingHandler playerSendingHandler;
    private final ErrorReporter reporter;
    private final Thread mainThread;
    private final ProtocolScheduler scheduler;
    private final AtomicInteger currentSendingIndex = new AtomicInteger();
    private ProtocolManager manager;

    public AsyncFilterManager(ErrorReporter reporter, ProtocolScheduler scheduler) {
        this.outboundTimeoutListeners = new OutboundPacketListenerSet(null, reporter);
        this.inboundTimeoutListeners = new InboundPacketListenerSet(null, reporter);
        this.timeoutListeners = ConcurrentHashMap.newKeySet();
        this.playerSendingHandler = new PlayerSendingHandler(this.outboundTimeoutListeners, this.inboundTimeoutListeners);
        this.serverProcessingQueue = new PacketProcessingQueue(this.playerSendingHandler);
        this.clientProcessingQueue = new PacketProcessingQueue(this.playerSendingHandler);
        this.playerSendingHandler.initializeScheduler();
        this.scheduler = scheduler;
        this.reporter = reporter;
        this.mainThread = Thread.currentThread();
    }

    public ProtocolManager getManager() {
        return this.manager;
    }

    public void setManager(ProtocolManager manager) {
        this.manager = manager;
    }

    @Override
    public AsyncListenerHandler registerAsyncHandler(PacketListener listener) {
        return this.registerAsyncHandler(listener, true);
    }

    @Override
    public void registerTimeoutHandler(PacketListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be NULL.");
        }
        if (!this.timeoutListeners.add(listener)) {
            return;
        }
        ListeningWhitelist sending = listener.getSendingWhitelist();
        ListeningWhitelist receiving = listener.getReceivingWhitelist();
        if (!ListeningWhitelist.isEmpty(sending)) {
            this.outboundTimeoutListeners.addListener(listener);
        }
        if (!ListeningWhitelist.isEmpty(receiving)) {
            this.inboundTimeoutListeners.addListener(listener);
        }
    }

    @Override
    public Set<PacketListener> getTimeoutHandlers() {
        return ImmutableSet.copyOf(this.timeoutListeners);
    }

    @Override
    public Set<PacketListener> getAsyncHandlers() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (AsyncListenerHandler handler : Iterables.concat(this.serverProcessingQueue.values(), this.clientProcessingQueue.values())) {
            builder.add((Object)handler.getAsyncListener());
        }
        return builder.build();
    }

    public AsyncListenerHandler registerAsyncHandler(PacketListener listener, boolean autoInject) {
        AsyncListenerHandler handler = new AsyncListenerHandler(this.mainThread, this, listener);
        ListeningWhitelist sendingWhitelist = listener.getSendingWhitelist();
        ListeningWhitelist receivingWhitelist = listener.getReceivingWhitelist();
        if (!this.hasValidWhitelist(sendingWhitelist) && !this.hasValidWhitelist(receivingWhitelist)) {
            throw new IllegalArgumentException("Listener has an empty sending and receiving whitelist.");
        }
        if (this.hasValidWhitelist(sendingWhitelist)) {
            this.manager.verifyWhitelist(listener, sendingWhitelist);
            this.serverProcessingQueue.addListener(handler, sendingWhitelist);
        }
        if (this.hasValidWhitelist(receivingWhitelist)) {
            this.manager.verifyWhitelist(listener, receivingWhitelist);
            this.clientProcessingQueue.addListener(handler, receivingWhitelist);
        }
        if (autoInject) {
            handler.setNullPacketListener(new NullPacketListener(listener));
            this.manager.addPacketListener(handler.getNullPacketListener());
        }
        return handler;
    }

    private boolean hasValidWhitelist(ListeningWhitelist whitelist) {
        return whitelist != null && whitelist.getTypes().size() > 0;
    }

    @Override
    public void unregisterTimeoutHandler(PacketListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be NULL.");
        }
        if (this.timeoutListeners.remove(listener)) {
            this.outboundTimeoutListeners.removeListener(listener);
            this.inboundTimeoutListeners.removeListener(listener);
        }
    }

    @Override
    public void unregisterAsyncHandler(PacketListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be NULL.");
        }
        AsyncListenerHandler handler = this.findHandler(this.serverProcessingQueue, listener.getSendingWhitelist(), listener);
        if (handler == null) {
            handler = this.findHandler(this.clientProcessingQueue, listener.getReceivingWhitelist(), listener);
        }
        this.unregisterAsyncHandler(handler);
    }

    private AsyncListenerHandler findHandler(PacketProcessingQueue queue, ListeningWhitelist search, PacketListener target) {
        if (ListeningWhitelist.isEmpty(search)) {
            return null;
        }
        for (PacketType type : search.getTypes()) {
            for (AsyncListenerHandler element : queue.get(type)) {
                if (element.getAsyncListener() != target) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public void unregisterAsyncHandler(AsyncListenerHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("listenerToken cannot be NULL");
        }
        handler.cancel();
    }

    void unregisterAsyncHandlerInternal(AsyncListenerHandler handler) {
        List<PacketType> removed;
        PacketListener listener = handler.getAsyncListener();
        boolean synchronusOK = this.onMainThread();
        if (handler.getNullPacketListener() != null) {
            this.manager.removePacketListener(handler.getNullPacketListener());
        }
        if (this.hasValidWhitelist(listener.getSendingWhitelist())) {
            removed = this.serverProcessingQueue.removeListener(handler, listener.getSendingWhitelist());
            this.playerSendingHandler.sendServerPackets(removed, synchronusOK);
        }
        if (this.hasValidWhitelist(listener.getReceivingWhitelist())) {
            removed = this.clientProcessingQueue.removeListener(handler, listener.getReceivingWhitelist());
            this.playerSendingHandler.sendClientPackets(removed, synchronusOK);
        }
    }

    private boolean onMainThread() {
        return Thread.currentThread().getId() == this.mainThread.getId();
    }

    @Override
    public void unregisterAsyncHandlers(Plugin plugin) {
        this.unregisterAsyncHandlers(this.serverProcessingQueue, plugin);
        this.unregisterAsyncHandlers(this.clientProcessingQueue, plugin);
    }

    private void unregisterAsyncHandlers(PacketProcessingQueue processingQueue, Plugin plugin) {
        for (AsyncListenerHandler listener : ImmutableList.copyOf(processingQueue.values())) {
            if (!Objects.equal((Object)listener.getPlugin(), (Object)plugin)) continue;
            this.unregisterAsyncHandler(listener);
        }
    }

    public synchronized void enqueueSyncPacket(PacketEvent syncPacket, AsyncMarker asyncMarker) {
        PacketEvent newEvent = PacketEvent.fromSynchronous(syncPacket, asyncMarker);
        if (asyncMarker.isQueued() || asyncMarker.isTransmitted()) {
            throw new IllegalArgumentException("Cannot queue a packet that has already been queued.");
        }
        asyncMarker.setQueuedSendingIndex(asyncMarker.getNewSendingIndex());
        Player player = syncPacket.getPlayer();
        if (player != null) {
            this.getSendingQueue(syncPacket).enqueue(newEvent);
            this.getProcessingQueue(syncPacket).enqueue(newEvent, true);
        }
    }

    @Override
    public Set<PacketType> getReceivingTypes() {
        return this.serverProcessingQueue.keySet();
    }

    @Override
    public Set<PacketType> getSendingTypes() {
        return this.clientProcessingQueue.keySet();
    }

    public ProtocolScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public boolean hasAsynchronousListeners(PacketEvent packet) {
        return this.getProcessingQueue(packet).contains(packet.getPacketType());
    }

    public AsyncMarker createAsyncMarker() {
        return this.createAsyncMarker(1800000L);
    }

    public AsyncMarker createAsyncMarker(long timeoutDelta) {
        return this.createAsyncMarker(timeoutDelta, this.currentSendingIndex.incrementAndGet());
    }

    private AsyncMarker createAsyncMarker(long timeoutDelta, long sendingIndex) {
        return new AsyncMarker(this.manager, sendingIndex, System.currentTimeMillis(), timeoutDelta);
    }

    @Override
    public PacketStream getPacketStream() {
        return this.manager;
    }

    @Override
    public ErrorReporter getErrorReporter() {
        return this.reporter;
    }

    @Override
    public void cleanupAll() {
        this.serverProcessingQueue.cleanupAll();
        this.playerSendingHandler.cleanupAll();
        this.timeoutListeners.clear();
        this.outboundTimeoutListeners = null;
        this.inboundTimeoutListeners = null;
    }

    @Override
    public void signalPacketTransmission(PacketEvent packet) {
        this.signalPacketTransmission(packet, this.onMainThread());
    }

    private void signalPacketTransmission(PacketEvent packet, boolean onMainThread) {
        AsyncMarker marker = packet.getAsyncMarker();
        if (marker == null) {
            throw new IllegalArgumentException("A sync packet cannot be transmitted by the asynchronous manager.");
        }
        if (!marker.isQueued()) {
            throw new IllegalArgumentException("A packet must have been queued before it can be transmitted.");
        }
        if (marker.decrementProcessingDelay() == 0) {
            if (!marker.hasExpired()) {
                while (marker.getListenerTraversal().hasNext()) {
                    AsyncListenerHandler handler = marker.getListenerTraversal().next();
                    if (handler.isCancelled()) continue;
                    marker.incrementProcessingDelay();
                    handler.enqueuePacket(packet);
                    return;
                }
            }
            this.signalFreeProcessingSlot(packet, onMainThread);
            PacketSendingQueue queue = this.getSendingQueue(packet, false);
            if (queue != null) {
                queue.signalPacketUpdate(packet, onMainThread);
            }
        }
    }

    public PacketSendingQueue getSendingQueue(PacketEvent packet) {
        return this.playerSendingHandler.getSendingQueue(packet);
    }

    public PacketSendingQueue getSendingQueue(PacketEvent packet, boolean createNew) {
        return this.playerSendingHandler.getSendingQueue(packet, createNew);
    }

    public PacketProcessingQueue getProcessingQueue(PacketEvent packet) {
        return packet.isServerPacket() ? this.serverProcessingQueue : this.clientProcessingQueue;
    }

    public void signalFreeProcessingSlot(PacketEvent packet, boolean onMainThread) {
        PacketProcessingQueue queue = this.getProcessingQueue(packet);
        queue.signalProcessingDone();
        queue.signalBeginProcessing(onMainThread);
    }

    public void sendProcessedPackets(int tickCounter, boolean onMainThread) {
        if (tickCounter % 10 == 0) {
            this.playerSendingHandler.trySendServerPackets(onMainThread);
        }
        this.playerSendingHandler.trySendClientPackets(onMainThread);
    }

    public void removePlayer(Player player) {
        this.playerSendingHandler.removePlayer(player);
    }
}

