/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

final class RangeParser {
    private RangeParser() {
    }

    public static List<Range<Integer>> getRanges(String text, Range<Integer> legalRange) {
        return RangeParser.getRanges(new ArrayDeque<String>(Collections.singletonList(text)), legalRange);
    }

    public static List<Range<Integer>> getRanges(Deque<String> input, Range<Integer> legalRange) {
        List<String> tokens = RangeParser.tokenizeInput(input);
        ArrayList<Range<Integer>> ranges = new ArrayList<Range<Integer>>();
        for (int i = 0; i < tokens.size(); ++i) {
            Range range;
            String next;
            String current = tokens.get(i);
            String string = next = i + 1 < tokens.size() ? tokens.get(i + 1) : null;
            if ("-".equals(current)) {
                throw new IllegalArgumentException("A hyphen must appear between two numbers.");
            }
            if ("-".equals(next)) {
                if (i + 2 >= tokens.size()) {
                    throw new IllegalArgumentException("Cannot form a range without a upper limit.");
                }
                range = Range.closed((Comparable)Integer.valueOf(Integer.parseInt(current)), (Comparable)Integer.valueOf(Integer.parseInt(tokens.get(i + 2))));
                ranges.add((Range<Integer>)range);
                i += 2;
            } else {
                range = Range.singleton((Comparable)Integer.valueOf(Integer.parseInt(current)));
                ranges.add((Range<Integer>)range);
            }
            if (legalRange.encloses(range)) continue;
            throw new IllegalArgumentException(String.valueOf(range) + " is not in the range " + range.toString());
        }
        return RangeParser.simplify(ranges, (Integer)legalRange.upperEndpoint());
    }

    private static List<Range<Integer>> simplify(List<Range<Integer>> ranges, int maximum) {
        ArrayList<Range<Integer>> result = new ArrayList<Range<Integer>>();
        boolean[] set = new boolean[maximum + 1];
        int start = -1;
        for (Range<Integer> range : ranges) {
            UnmodifiableIterator unmodifiableIterator = ContiguousSet.create(range, (DiscreteDomain)DiscreteDomain.integers()).iterator();
            while (unmodifiableIterator.hasNext()) {
                int id = (Integer)unmodifiableIterator.next();
                set[id] = true;
            }
        }
        for (int i = 0; i <= set.length; ++i) {
            if (i < set.length && set[i]) {
                if (start >= 0) continue;
                start = i;
                continue;
            }
            if (start < 0) continue;
            result.add((Range<Integer>)Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(i - 1)));
            start = -1;
        }
        return result;
    }

    private static List<String> tokenizeInput(Deque<String> input) {
        ArrayList<String> tokens = new ArrayList<String>();
        while (!input.isEmpty()) {
            StringBuilder number = new StringBuilder();
            String text = input.peek();
            for (int j = 0; j < text.length(); ++j) {
                char current = text.charAt(j);
                if (Character.isDigit(current)) {
                    number.append(current);
                    continue;
                }
                if (Character.isWhitespace(current)) continue;
                if (current == '-') {
                    if (number.length() > 0) {
                        tokens.add(number.toString());
                        number.setLength(0);
                    }
                    tokens.add(Character.toString(current));
                    continue;
                }
                return tokens;
            }
            if (number.length() > 0) {
                tokens.add(number.toString());
            }
            input.poll();
        }
        return tokens;
    }
}

