/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class ProtocolConfig {
    private static final String LAST_UPDATE_FILE = "lastupdate";
    private static final String SECTION_GLOBAL = "global";
    private static final String SECTION_AUTOUPDATER = "auto updater";
    private static final String METRICS_ENABLED = "metrics";
    private static final String IGNORE_VERSION_CHECK = "ignore version check";
    private static final String DEBUG_MODE_ENABLED = "debug";
    private static final String DETAILED_ERROR = "detailed error";
    private static final String CHAT_WARNINGS = "chat warnings";
    private static final String SCRIPT_ENGINE_NAME = "script engine";
    private static final String SUPPRESSED_REPORTS = "suppressed reports";
    private static final String UPDATER_NOTIFY = "notify";
    private static final String UPDATER_DOWNLAD = "download";
    private static final String UPDATER_DELAY = "delay";
    private static final long DEFAULT_UPDATER_DELAY = 43200L;
    private Plugin plugin;
    private Configuration config;
    private boolean loadingSections;
    private ConfigurationSection global;
    private ConfigurationSection updater;
    private long lastUpdateTime;
    private boolean configChanged;
    private boolean valuesChanged;
    private int modCount;

    public ProtocolConfig(Plugin plugin) {
        this.plugin = plugin;
        this.reloadConfig();
    }

    public void reloadConfig() {
        this.configChanged = false;
        this.valuesChanged = false;
        ++this.modCount;
        this.config = this.plugin.getConfig();
        this.lastUpdateTime = this.loadLastUpdate();
        this.loadSections(!this.loadingSections);
    }

    private long loadLastUpdate() {
        File dataFile = this.getLastUpdateFile();
        if (dataFile.exists()) {
            try {
                return Long.parseLong(Files.toString((File)dataFile, (Charset)StandardCharsets.UTF_8));
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Cannot parse " + String.valueOf(dataFile) + " as a number.");
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Cannot read " + String.valueOf(dataFile));
            }
        }
        return 0L;
    }

    private void saveLastUpdate(long value) {
        File dataFile = this.getLastUpdateFile();
        dataFile.getParentFile().mkdirs();
        if (dataFile.exists()) {
            dataFile.delete();
        }
        try {
            Files.write((CharSequence)Long.toString(value), (File)dataFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write " + String.valueOf(dataFile), e);
        }
    }

    private File getLastUpdateFile() {
        return new File(this.plugin.getDataFolder(), LAST_UPDATE_FILE);
    }

    private void loadSections(boolean copyDefaults) {
        if (this.config != null) {
            this.global = this.config.getConfigurationSection(SECTION_GLOBAL);
        }
        if (this.global != null) {
            this.updater = this.global.getConfigurationSection(SECTION_AUTOUPDATER);
            if (this.updater.getValues(true).isEmpty()) {
                this.plugin.getLogger().warning("Updater section is missing, regenerate your config!");
            }
        }
        if (copyDefaults && (!this.getFile().exists() || this.global == null || this.updater == null)) {
            this.loadingSections = true;
            if (this.config != null) {
                this.config.options().copyDefaults(true);
            }
            this.plugin.saveDefaultConfig();
            this.plugin.reloadConfig();
            this.loadingSections = false;
            this.plugin.getLogger().info("Created default configuration.");
        }
    }

    private void setConfig(ConfigurationSection section, String path, Object value) {
        this.configChanged = true;
        section.set(path, value);
    }

    private <T> T getGlobalValue(String path, T def) {
        try {
            return (T)this.global.get(path, def);
        }
        catch (Throwable ex) {
            return def;
        }
    }

    private <T> T getUpdaterValue(String path, T def) {
        try {
            return (T)this.updater.get(path, def);
        }
        catch (Throwable ex) {
            return def;
        }
    }

    public File getFile() {
        return new File(this.plugin.getDataFolder(), "config.yml");
    }

    public boolean isDetailedErrorReporting() {
        return this.getGlobalValue(DETAILED_ERROR, false);
    }

    public boolean isChatWarnings() {
        return this.getGlobalValue(CHAT_WARNINGS, true);
    }

    public boolean isAutoNotify() {
        return this.getUpdaterValue(UPDATER_NOTIFY, true);
    }

    public boolean isAutoDownload() {
        return this.updater != null && this.getUpdaterValue(UPDATER_DOWNLAD, false) != false;
    }

    public boolean isDebug() {
        return this.getGlobalValue(DEBUG_MODE_ENABLED, false);
    }

    public void setDebug(boolean value) {
        this.setConfig(this.global, DEBUG_MODE_ENABLED, value);
        ++this.modCount;
    }

    public ImmutableList<String> getSuppressedReports() {
        return ImmutableList.copyOf((Collection)this.getGlobalValue(SUPPRESSED_REPORTS, new ArrayList()));
    }

    public long getAutoDelay() {
        return Math.max((long)this.getUpdaterValue(UPDATER_DELAY, 0).intValue(), 43200L);
    }

    public String getIgnoreVersionCheck() {
        return this.getGlobalValue(IGNORE_VERSION_CHECK, "");
    }

    public boolean isMetricsEnabled() {
        return this.getGlobalValue(METRICS_ENABLED, true);
    }

    public long getAutoLastTime() {
        return this.lastUpdateTime;
    }

    public void setAutoLastTime(long lastTimeSeconds) {
        this.valuesChanged = true;
        this.lastUpdateTime = lastTimeSeconds;
    }

    public String getScriptEngineName() {
        return this.getGlobalValue(SCRIPT_ENGINE_NAME, "JavaScript");
    }

    public void setScriptEngineName(String name) {
        this.setConfig(this.global, SCRIPT_ENGINE_NAME, name);
        ++this.modCount;
    }

    public int getModificationCount() {
        return this.modCount;
    }

    public void saveAll() {
        if (this.valuesChanged) {
            this.saveLastUpdate(this.lastUpdateTime);
        }
        if (this.configChanged) {
            this.plugin.saveConfig();
        }
        this.valuesChanged = false;
        this.configChanged = false;
    }
}

