/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.core.scoreboard.line;

import com.r4g3baby.simplescore.api.scoreboard.VarReplacer;
import com.r4g3baby.simplescore.api.scoreboard.condition.Condition;
import com.r4g3baby.simplescore.api.scoreboard.effect.TextEffect;
import com.r4g3baby.simplescore.core.scoreboard.line.ScoreboardLine;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.collections.CollectionsKt;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.DefaultConstructorMarker;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import java.util.List;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001fB;\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J#\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\n\u0010\u001e\u001a\u00020\u0019H\u0096\u0080\u0004R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR \u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/r4g3baby/simplescore/core/scoreboard/line/AnimatedLine;", "V", "", "Lcom/r4g3baby/simplescore/core/scoreboard/line/ScoreboardLine;", "frames", "", "Lcom/r4g3baby/simplescore/core/scoreboard/line/AnimatedLine$Frame;", "textEffects", "Lcom/r4g3baby/simplescore/api/scoreboard/effect/TextEffect;", "conditions", "Lcom/r4g3baby/simplescore/api/scoreboard/condition/Condition;", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getFrames", "()Ljava/util/List;", "getTextEffects", "getConditions", "currentIndex", "", "currentTick", "tick", "", "shouldRender", "", "currentText", "", "viewer", "varReplacer", "Lcom/r4g3baby/simplescore/api/scoreboard/VarReplacer;", "(Ljava/lang/Object;Lcom/r4g3baby/simplescore/api/scoreboard/VarReplacer;)Ljava/lang/String;", "toString", "Frame", "core"})
public final class AnimatedLine<V>
extends ScoreboardLine<V> {
    @NotNull
    private final List<Frame> frames;
    @NotNull
    private final List<TextEffect> textEffects;
    @NotNull
    private final List<Condition<V>> conditions;
    private int currentIndex;
    private int currentTick;

    public AnimatedLine(@NotNull List<Frame> frames, @NotNull List<? extends TextEffect> textEffects, @NotNull List<? extends Condition<V>> conditions) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        Intrinsics.checkNotNullParameter(textEffects, "textEffects");
        Intrinsics.checkNotNullParameter(conditions, "conditions");
        this.frames = frames;
        this.textEffects = textEffects;
        this.conditions = conditions;
        this.currentTick = 1;
    }

    public /* synthetic */ AnimatedLine(List list, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        this(list, list2, list3);
    }

    @NotNull
    public final List<Frame> getFrames() {
        return this.frames;
    }

    @Override
    @NotNull
    public List<TextEffect> getTextEffects() {
        return this.textEffects;
    }

    @Override
    @NotNull
    public List<Condition<V>> getConditions() {
        return this.conditions;
    }

    @Override
    public void tick() {
        if (this.frames.isEmpty()) {
            return;
        }
        int n = this.currentTick;
        this.currentTick = n + 1;
        if (n >= this.frames.get(this.currentIndex).getVisibleFor()) {
            n = this.currentIndex;
            this.currentIndex = n + 1;
            if (n >= this.frames.size() - 1) {
                this.currentIndex = 0;
            }
            this.currentTick = 1;
        }
    }

    @Override
    public boolean shouldRender() {
        if (this.frames.isEmpty()) {
            return false;
        }
        if (this.currentTick == 1) {
            return true;
        }
        Frame frame = this.frames.get(this.currentIndex);
        if (frame.getVisibleFor() == this.currentTick && frame.getRenderEvery() == this.currentTick) {
            return false;
        }
        return this.currentTick % frame.getRenderEvery() == 0;
    }

    @Override
    @NotNull
    public String currentText(@NotNull V viewer, @NotNull VarReplacer<V> varReplacer) {
        Intrinsics.checkNotNullParameter(viewer, "viewer");
        Intrinsics.checkNotNullParameter(varReplacer, "varReplacer");
        if (this.frames.isEmpty()) {
            return "";
        }
        return this.applyEffects(varReplacer.replace(this.frames.get(this.currentIndex).getText(), viewer));
    }

    @NotNull
    public String toString() {
        return "AnimatedLine(frames=" + this.frames + ", textEffects=" + this.getTextEffects() + ", conditions=" + this.getConditions() + ')';
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u000e\u001a\u00020\u0003H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/r4g3baby/simplescore/core/scoreboard/line/AnimatedLine$Frame;", "", "text", "", "visibleFor", "", "renderEvery", "<init>", "(Ljava/lang/String;II)V", "getText", "()Ljava/lang/String;", "getVisibleFor", "()I", "getRenderEvery", "toString", "core"})
    public static final class Frame {
        @NotNull
        private final String text;
        private final int visibleFor;
        private final int renderEvery;

        public Frame(@NotNull String text, int visibleFor, int renderEvery) {
            Intrinsics.checkNotNullParameter(text, "text");
            this.text = text;
            this.visibleFor = visibleFor;
            this.renderEvery = renderEvery;
        }

        public /* synthetic */ Frame(String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = 20;
            }
            if ((n3 & 4) != 0) {
                n2 = 10;
            }
            this(string, n, n2);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final int getVisibleFor() {
            return this.visibleFor;
        }

        public final int getRenderEvery() {
            return this.renderEvery;
        }

        @NotNull
        public String toString() {
            return "Frame(text=" + this.text + ", visibleFor=" + this.visibleFor + ", renderEvery=" + this.renderEvery + ')';
        }
    }
}

