/*
 * Decompiled with CFR 0.152.
 */
package com.r4g3baby.simplescore.bukkit.listener;

import com.r4g3baby.simplescore.bukkit.BukkitManager;
import com.r4g3baby.simplescore.bukkit.scoreboard.data.Viewer;
import com.r4g3baby.simplescore.lib.jetbrains.annotations.NotNull;
import com.r4g3baby.simplescore.lib.kotlin.Metadata;
import com.r4g3baby.simplescore.lib.kotlin.jvm.internal.Intrinsics;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0013H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/r4g3baby/simplescore/bukkit/listener/PlayerListener;", "Lorg/bukkit/event/Listener;", "manager", "Lcom/r4g3baby/simplescore/bukkit/BukkitManager;", "<init>", "(Lcom/r4g3baby/simplescore/bukkit/BukkitManager;)V", "onPlayerJoin", "", "e", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onPlayerKick", "Lorg/bukkit/event/player/PlayerKickEvent;", "onPlayerChangedWorld", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onPlayerTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "bukkit"})
public final class PlayerListener
implements Listener {
    @NotNull
    private final BukkitManager manager;

    public PlayerListener(@NotNull BukkitManager manager) {
        Intrinsics.checkNotNullParameter(manager, "manager");
        this.manager = manager;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerJoin(@NotNull PlayerJoinEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Viewer viewer = this.manager.getOrCreateViewer$bukkit(player);
        World world = e.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        this.manager.onViewerChangeWorld$bukkit(viewer, world);
        Location location = e.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.manager.onViewerChangeLocation$bukkit(viewer, location);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerQuit(@NotNull PlayerQuitEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        UUID uUID = e.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.manager.removeViewer$bukkit(uUID);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onPlayerKick(@NotNull PlayerKickEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        UUID uUID = e.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.manager.removeViewer$bukkit(uUID);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerChangedWorld(@NotNull PlayerChangedWorldEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter(e, "e");
            UUID uUID = e.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Viewer viewer = this.manager.getViewer(uUID);
            if (viewer == null) break block0;
            Viewer viewer2 = viewer;
            boolean bl = false;
            World world = e.getPlayer().getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            this.manager.onViewerChangeWorld$bukkit(viewer2, world);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public final void onPlayerMove(@NotNull PlayerMoveEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter(e, "e");
            if (e.getFrom().getBlockX() == e.getTo().getBlockX() && e.getFrom().getBlockY() == e.getTo().getBlockY() && e.getFrom().getBlockZ() == e.getTo().getBlockZ()) {
                return;
            }
            UUID uUID = e.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Viewer viewer = this.manager.getViewer(uUID);
            if (viewer == null) break block1;
            Viewer viewer2 = viewer;
            boolean bl = false;
            Location location = e.getTo();
            Intrinsics.checkNotNullExpressionValue(location, "getTo(...)");
            this.manager.onViewerChangeLocation$bukkit(viewer2, location);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onPlayerTeleport(@NotNull PlayerTeleportEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter(e, "e");
            UUID uUID = e.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Viewer viewer = this.manager.getViewer(uUID);
            if (viewer == null) break block1;
            Viewer viewer2 = viewer;
            boolean bl = false;
            if (!Intrinsics.areEqual(e.getFrom().getWorld(), e.getTo().getWorld())) {
                World world = e.getTo().getWorld();
                Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
                this.manager.onViewerChangeWorld$bukkit(viewer2, world);
            }
            Location location = e.getTo();
            Intrinsics.checkNotNullExpressionValue(location, "getTo(...)");
            this.manager.onViewerChangeLocation$bukkit(viewer2, location);
        }
    }
}

