/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.math;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.LegacyFastMath;
import ac.grim.grimac.utils.math.OptifineFastMath;
import ac.grim.grimac.utils.math.VanillaMath;
import ac.grim.grimac.utils.math.Vector3dm;
import lombok.Generated;

public class TrigHandler {
    private final GrimPlayer player;
    private double buffer = 0.0;
    private boolean isVanillaMath = true;

    public TrigHandler(GrimPlayer player) {
        this.player = player;
    }

    public void toggleShitMath() {
        this.isVanillaMath = !this.isVanillaMath;
    }

    public Vector3dm getVanillaMathMovement(Vector3dm wantedMovement, float f, float f2) {
        float f3 = VanillaMath.sin(GrimMath.radians(f2));
        float f4 = VanillaMath.cos(GrimMath.radians(f2));
        float bestTheoreticalX = (float)((double)f3 * wantedMovement.getZ() + (double)f4 * wantedMovement.getX()) / (f3 * f3 + f4 * f4) / f;
        float bestTheoreticalZ = (float)((double)(-f3) * wantedMovement.getX() + (double)f4 * wantedMovement.getZ()) / (f3 * f3 + f4 * f4) / f;
        return new Vector3dm(bestTheoreticalX, 0.0f, bestTheoreticalZ);
    }

    public Vector3dm getShitMathMovement(Vector3dm wantedMovement, float f, float f2) {
        float f3 = this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8) ? OptifineFastMath.sin(GrimMath.radians(f2)) : LegacyFastMath.sin(GrimMath.radians(f2));
        float f4 = this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8) ? OptifineFastMath.cos(GrimMath.radians(f2)) : LegacyFastMath.cos(GrimMath.radians(f2));
        float bestTheoreticalX = (float)((double)f3 * wantedMovement.getZ() + (double)f4 * wantedMovement.getX()) / (f3 * f3 + f4 * f4) / f;
        float bestTheoreticalZ = (float)((double)(-f3) * wantedMovement.getX() + (double)f4 * wantedMovement.getZ()) / (f3 * f3 + f4 * f4) / f;
        return new Vector3dm(bestTheoreticalX, 0.0f, bestTheoreticalZ);
    }

    public void setOffset(double offset) {
        if (offset == 0.0 || offset > 0.001) {
            return;
        }
        if (offset > 1.0E-5) {
            Vector3dm trueMovement = this.player.actualMovement.clone().subtract(this.player.startTickClientVel);
            Vector3dm correctMath = this.getVanillaMathMovement(trueMovement, 0.1f, this.player.xRot);
            Vector3dm fastMath = this.getShitMathMovement(trueMovement, 0.1f, this.player.xRot);
            correctMath = new Vector3dm(Math.abs(correctMath.getX()), 0.0, Math.abs(correctMath.getZ()));
            fastMath = new Vector3dm(Math.abs(fastMath.getX()), 0.0, Math.abs(fastMath.getZ()));
            double minCorrectHorizontal = Math.min(correctMath.getX(), correctMath.getZ());
            minCorrectHorizontal = Math.min(minCorrectHorizontal, Math.abs(correctMath.getX() - correctMath.getZ()));
            double minFastMathHorizontal = Math.min(fastMath.getX(), fastMath.getZ());
            boolean newVanilla = minCorrectHorizontal < (minFastMathHorizontal = Math.min(minFastMathHorizontal, Math.abs(fastMath.getX() - fastMath.getZ())));
            this.buffer += newVanilla != this.isVanillaMath ? 1.0 : -0.25;
            if (this.buffer > 5.0) {
                this.buffer = 0.0;
                this.isVanillaMath = !this.isVanillaMath;
            }
            this.buffer = Math.max(0.0, this.buffer);
        }
    }

    public float sin(float value) {
        return this.isVanillaMath ? VanillaMath.sin(value) : (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8) ? OptifineFastMath.sin(value) : LegacyFastMath.sin(value));
    }

    public float cos(float value) {
        return this.isVanillaMath ? VanillaMath.cos(value) : (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8) ? OptifineFastMath.cos(value) : LegacyFastMath.cos(value));
    }

    @Generated
    public boolean isVanillaMath() {
        return this.isVanillaMath;
    }
}

