/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.incendo.cloud.permission;

import ac.grim.grimac.shaded.incendo.cloud.key.CloudKey;
import ac.grim.grimac.shaded.incendo.cloud.key.CloudKeyHolder;
import ac.grim.grimac.shaded.incendo.cloud.permission.Permission;
import ac.grim.grimac.shaded.incendo.cloud.permission.PermissionResult;
import ac.grim.grimac.shaded.incendo.cloud.permission.WrappingPredicatePermission;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
@API(status=API.Status.STABLE)
public interface PredicatePermission<C>
extends Permission,
CloudKeyHolder<Void> {
    public static <C> PredicatePermission<C> of(@NonNull CloudKey<Void> key, @NonNull Predicate<C> predicate) {
        return new WrappingPredicatePermission<C>(key, predicate);
    }

    public static <C> PredicatePermission<C> of(final @NonNull Predicate<C> predicate) {
        return new PredicatePermission<C>(){

            @Override
            public @NonNull PermissionResult testPermission(@NonNull C sender) {
                return PermissionResult.of(predicate.test(sender), this);
            }
        };
    }

    @Override
    default public @NonNull CloudKey<Void> key() {
        return CloudKey.of(this.getClass().getSimpleName());
    }

    @Override
    default public @NonNull String permissionString() {
        return this.key().name();
    }

    @API(status=API.Status.STABLE)
    public @NonNull PermissionResult testPermission(@NonNull C var1);

    @Override
    default public boolean isEmpty() {
        return false;
    }
}

