/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.bukkit.utils.convert;

import ac.grim.grimac.platform.api.permissions.PermissionDefaultValue;
import ac.grim.grimac.platform.bukkit.world.BukkitPlatformWorld;
import ac.grim.grimac.shaded.jetbrains.annotations.Contract;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.utils.math.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.permissions.PermissionDefault;

public class BukkitConversionUtils {
    @Contract(value="null -> null; !null -> new")
    public static org.bukkit.Location toBukkitLocation(Location location) {
        if (location == null) {
            return null;
        }
        return new org.bukkit.Location(((BukkitPlatformWorld)location.getWorld()).getBukkitWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    @Nullable
    public static PermissionDefault toBukkitPermissionDefault(@Nullable PermissionDefaultValue permissionDefaultValue) {
        if (permissionDefaultValue == null) {
            return null;
        }
        return switch (permissionDefaultValue) {
            default -> throw new IncompatibleClassChangeError();
            case PermissionDefaultValue.TRUE -> PermissionDefault.TRUE;
            case PermissionDefaultValue.FALSE -> PermissionDefault.FALSE;
            case PermissionDefaultValue.OP -> PermissionDefault.OP;
            case PermissionDefaultValue.NOT_OP -> PermissionDefault.NOT_OP;
        };
    }

    @Deprecated
    public static ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace fromBukkitFace(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace.NORTH;
            case BlockFace.SOUTH -> ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace.SOUTH;
            case BlockFace.WEST -> ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace.WEST;
            case BlockFace.EAST -> ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace.EAST;
            case BlockFace.UP -> ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace.UP;
            case BlockFace.DOWN -> ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace.DOWN;
            default -> ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace.OTHER;
        };
    }
}

