/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.events.packets;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerInitializeWorldBorder;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWorldBorder;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWorldBorderCenter;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWorldBorderSize;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayWorldBorderLerpSize;
import ac.grim.grimac.shaded.jetbrains.annotations.Contract;
import ac.grim.grimac.utils.math.GrimMath;
import lombok.Generated;

public class PacketWorldBorder
extends Check
implements PacketCheck {
    private double centerX;
    private double centerZ;
    private double oldDiameter;
    private double newDiameter;
    private double absoluteMaxSize;
    private long startTime = 1L;
    private long endTime = 1L;

    public PacketWorldBorder(GrimPlayer playerData) {
        super(playerData);
    }

    public double getCurrentDiameter() {
        double d0 = (double)(System.currentTimeMillis() - this.startTime) / ((double)this.endTime - (double)this.startTime);
        return d0 < 1.0 ? GrimMath.lerp(d0, this.oldDiameter, this.newDiameter) : this.newDiameter;
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        int portalTeleportBoundary;
        long speed;
        double newDiameter;
        double centerZ;
        double centerX;
        long speed2;
        double newDiameter2;
        double oldDiameter;
        PacketWrapper packet;
        if (event.getPacketType() == PacketType.Play.Server.WORLD_BORDER) {
            packet = new WrapperPlayServerWorldBorder(event);
            this.player.sendTransaction();
            if (((WrapperPlayServerWorldBorder)packet).getAction() == WrapperPlayServerWorldBorder.WorldBorderAction.SET_SIZE) {
                double size = ((WrapperPlayServerWorldBorder)packet).getRadius();
                this.player.addRealTimeTaskNow(() -> this.setSize(size));
            } else if (((WrapperPlayServerWorldBorder)packet).getAction() == WrapperPlayServerWorldBorder.WorldBorderAction.LERP_SIZE) {
                oldDiameter = ((WrapperPlayServerWorldBorder)packet).getOldRadius();
                newDiameter2 = ((WrapperPlayServerWorldBorder)packet).getNewRadius();
                speed2 = ((WrapperPlayServerWorldBorder)packet).getSpeed();
                this.player.addRealTimeTaskNow(() -> this.setLerp(oldDiameter, newDiameter2, speed2));
            } else if (((WrapperPlayServerWorldBorder)packet).getAction() == WrapperPlayServerWorldBorder.WorldBorderAction.SET_CENTER) {
                centerX = ((WrapperPlayServerWorldBorder)packet).getCenterX();
                centerZ = ((WrapperPlayServerWorldBorder)packet).getCenterZ();
                this.player.addRealTimeTaskNow(() -> this.setCenter(centerX, centerZ));
            } else if (((WrapperPlayServerWorldBorder)packet).getAction() == WrapperPlayServerWorldBorder.WorldBorderAction.INITIALIZE) {
                centerX = ((WrapperPlayServerWorldBorder)packet).getCenterX();
                centerZ = ((WrapperPlayServerWorldBorder)packet).getCenterZ();
                double oldDiameter2 = ((WrapperPlayServerWorldBorder)packet).getOldRadius();
                newDiameter = ((WrapperPlayServerWorldBorder)packet).getNewRadius();
                speed = ((WrapperPlayServerWorldBorder)packet).getSpeed();
                portalTeleportBoundary = ((WrapperPlayServerWorldBorder)packet).getPortalTeleportBoundary();
                this.player.addRealTimeTaskNow(() -> {
                    this.setCenter(centerX, centerZ);
                    this.setLerp(oldDiameter2, newDiameter, speed);
                    this.absoluteMaxSize = portalTeleportBoundary;
                });
            }
        }
        if (event.getPacketType() == PacketType.Play.Server.INITIALIZE_WORLD_BORDER) {
            this.player.sendTransaction();
            packet = new WrapperPlayServerInitializeWorldBorder(event);
            centerX = ((WrapperPlayServerInitializeWorldBorder)packet).getX();
            centerZ = ((WrapperPlayServerInitializeWorldBorder)packet).getZ();
            double oldDiameter3 = ((WrapperPlayServerInitializeWorldBorder)packet).getOldDiameter();
            newDiameter = ((WrapperPlayServerInitializeWorldBorder)packet).getNewDiameter();
            speed = ((WrapperPlayServerInitializeWorldBorder)packet).getSpeed();
            portalTeleportBoundary = ((WrapperPlayServerInitializeWorldBorder)packet).getPortalTeleportBoundary();
            this.player.addRealTimeTaskNow(() -> {
                this.setCenter(centerX, centerZ);
                this.setLerp(oldDiameter3, newDiameter, speed);
                this.absoluteMaxSize = portalTeleportBoundary;
            });
        }
        if (event.getPacketType() == PacketType.Play.Server.WORLD_BORDER_CENTER) {
            this.player.sendTransaction();
            packet = new WrapperPlayServerWorldBorderCenter(event);
            centerX = ((WrapperPlayServerWorldBorderCenter)packet).getX();
            centerZ = ((WrapperPlayServerWorldBorderCenter)packet).getZ();
            this.player.addRealTimeTaskNow(() -> this.setCenter(centerX, centerZ));
        }
        if (event.getPacketType() == PacketType.Play.Server.WORLD_BORDER_SIZE) {
            this.player.sendTransaction();
            double size = new WrapperPlayServerWorldBorderSize(event).getDiameter();
            this.player.addRealTimeTaskNow(() -> this.setSize(size));
        }
        if (event.getPacketType() == PacketType.Play.Server.WORLD_BORDER_LERP_SIZE) {
            this.player.sendTransaction();
            WrapperPlayWorldBorderLerpSize packet2 = new WrapperPlayWorldBorderLerpSize(event);
            oldDiameter = packet2.getOldDiameter();
            newDiameter2 = packet2.getNewDiameter();
            speed2 = packet2.getSpeed();
            this.player.addRealTimeTaskNow(() -> this.setLerp(oldDiameter, newDiameter2, speed2));
        }
    }

    @Contract(mutates="this")
    private void setCenter(double x, double z) {
        this.centerX = x;
        this.centerZ = z;
    }

    @Contract(mutates="this")
    private void setSize(double size) {
        this.oldDiameter = size;
        this.newDiameter = size;
    }

    @Contract(mutates="this")
    private void setLerp(double oldDiameter, double newDiameter, long length) {
        this.oldDiameter = oldDiameter;
        this.newDiameter = newDiameter;
        this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + length;
    }

    @Generated
    public double getCenterX() {
        return this.centerX;
    }

    @Generated
    public double getCenterZ() {
        return this.centerZ;
    }

    @Generated
    public double getAbsoluteMaxSize() {
        return this.absoluteMaxSize;
    }
}

