/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.api.event;

import ac.grim.grimac.api.event.EventBus;
import ac.grim.grimac.api.event.GrimEvent;
import ac.grim.grimac.api.event.GrimEventHandler;
import ac.grim.grimac.api.event.GrimEventListener;
import ac.grim.grimac.api.event.events.CommandExecuteEvent;
import ac.grim.grimac.api.event.events.CompletePredictionEvent;
import ac.grim.grimac.api.event.events.FlagEvent;
import ac.grim.grimac.api.event.events.GrimJoinEvent;
import ac.grim.grimac.api.event.events.GrimQuitEvent;
import ac.grim.grimac.api.event.events.GrimReloadEvent;
import ac.grim.grimac.api.plugin.GrimPlugin;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

public class OptimizedEventBus
implements EventBus {
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final Map<Class<? extends GrimEvent>, AtomicReference<OptimizedListener[]>> listenerMap = new ConcurrentHashMap<Class<? extends GrimEvent>, AtomicReference<OptimizedListener[]>>();

    public OptimizedEventBus() {
        this.prefillKnownEventTypes(this.listenerMap);
    }

    private void prefillKnownEventTypes(Map<Class<? extends GrimEvent>, AtomicReference<OptimizedListener[]>> map) {
        map.put(GrimReloadEvent.class, new AtomicReference<OptimizedListener[]>(new OptimizedListener[0]));
        map.put(GrimQuitEvent.class, new AtomicReference<OptimizedListener[]>(new OptimizedListener[0]));
        map.put(GrimJoinEvent.class, new AtomicReference<OptimizedListener[]>(new OptimizedListener[0]));
        map.put(FlagEvent.class, new AtomicReference<OptimizedListener[]>(new OptimizedListener[0]));
        map.put(CommandExecuteEvent.class, new AtomicReference<OptimizedListener[]>(new OptimizedListener[0]));
        map.put(CompletePredictionEvent.class, new AtomicReference<OptimizedListener[]>(new OptimizedListener[0]));
        map.put(GrimEvent.class, new AtomicReference<OptimizedListener[]>(new OptimizedListener[0]));
    }

    @Override
    public void registerAnnotatedListeners(GrimPlugin plugin, @NotNull Object listener) {
        this.registerMethods(plugin, listener, listener.getClass());
    }

    @Override
    public void registerStaticAnnotatedListeners(GrimPlugin plugin, @NotNull Class<?> clazz) {
        this.registerMethods(plugin, null, clazz);
    }

    private void registerMethods(GrimPlugin plugin, @Nullable Object instance, @NotNull Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            Class<?> eventType;
            GrimEventHandler annotation = method.getAnnotation(GrimEventHandler.class);
            if (annotation == null || method.getParameterCount() != 1 || !GrimEvent.class.isAssignableFrom(eventType = method.getParameterTypes()[0])) continue;
            try {
                if (instance == null && !Modifier.isStatic(method.getModifiers())) continue;
                method.setAccessible(true);
                MethodHandle handle = this.lookup.unreflect(method);
                GrimEventListener<GrimEvent> listener = event -> {
                    try {
                        if (instance != null) {
                            handle.invoke(instance, event);
                        } else {
                            handle.invoke(event);
                        }
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException("Failed to invoke listener for " + eventType.getName(), throwable);
                    }
                };
                Class<?> currentEventType = eventType;
                while (GrimEvent.class.isAssignableFrom(currentEventType)) {
                    OptimizedListener optimizedListener = new OptimizedListener(plugin, listener, annotation.priority(), annotation.ignoreCancelled(), method.getDeclaringClass(), instance);
                    this.addListener(currentEventType, optimizedListener);
                    currentEventType = currentEventType.getSuperclass();
                }
            }
            catch (IllegalAccessException e) {
                System.err.println("Failed to register listener for " + eventType.getName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void addListener(Class<? extends GrimEvent> eventType, OptimizedListener newListener) {
        OptimizedListener[] newArray;
        OptimizedListener[] oldArray;
        AtomicReference ref = this.listenerMap.computeIfAbsent(eventType, k -> new AtomicReference<OptimizedListener[]>(new OptimizedListener[0]));
        do {
            int insertionPoint;
            if ((insertionPoint = Arrays.binarySearch(oldArray = (OptimizedListener[])ref.get(), newListener, (a, b) -> Integer.compare(b.priority, a.priority))) < 0) {
                insertionPoint = -(insertionPoint + 1);
            } else {
                while (insertionPoint < oldArray.length - 1 && oldArray[insertionPoint + 1].priority == newListener.priority) {
                    ++insertionPoint;
                }
                ++insertionPoint;
            }
            newArray = new OptimizedListener[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, insertionPoint);
            newArray[insertionPoint] = newListener;
            System.arraycopy(oldArray, insertionPoint, newArray, insertionPoint + 1, oldArray.length - insertionPoint);
        } while (!ref.compareAndSet(oldArray, newArray));
    }

    @Override
    public void unregisterListeners(GrimPlugin plugin, Object instance) {
        for (Map.Entry<Class<? extends GrimEvent>, AtomicReference<OptimizedListener[]>> entry : this.listenerMap.entrySet()) {
            this.removeListeners(entry.getKey(), entry.getValue(), listener -> listener.plugin.equals(plugin) && listener.instance != null && listener.instance.equals(instance));
        }
    }

    @Override
    public void unregisterStaticListeners(GrimPlugin plugin, Class<?> clazz) {
        for (Map.Entry<Class<? extends GrimEvent>, AtomicReference<OptimizedListener[]>> entry : this.listenerMap.entrySet()) {
            this.removeListeners(entry.getKey(), entry.getValue(), listener -> listener.plugin.equals(plugin) && listener.instance == null && listener.declaringClass.equals(clazz));
        }
    }

    @Override
    public void unregisterAllListeners(GrimPlugin plugin) {
        for (Map.Entry<Class<? extends GrimEvent>, AtomicReference<OptimizedListener[]>> entry : this.listenerMap.entrySet()) {
            this.removeListeners(entry.getKey(), entry.getValue(), listener -> listener.plugin.equals(plugin));
        }
    }

    @Override
    public void unregisterListener(GrimPlugin plugin, GrimEventListener<?> eventListener) {
        for (Map.Entry<Class<? extends GrimEvent>, AtomicReference<OptimizedListener[]>> entry : this.listenerMap.entrySet()) {
            this.removeListeners(entry.getKey(), entry.getValue(), listener -> listener.plugin.equals(plugin) && listener.listener.equals(eventListener));
        }
    }

    private void removeListeners(Class<? extends GrimEvent> eventType, AtomicReference<OptimizedListener[]> ref, Predicate<OptimizedListener> filter) {
        block4: {
            OptimizedListener[] newArray;
            OptimizedListener[] oldArray;
            do {
                oldArray = ref.get();
                int remaining = 0;
                for (OptimizedListener listener : oldArray) {
                    if (filter.test(listener)) continue;
                    ++remaining;
                }
                if (remaining == oldArray.length) {
                    return;
                }
                newArray = new OptimizedListener[remaining];
                int index = 0;
                for (OptimizedListener listener : oldArray) {
                    if (filter.test(listener)) continue;
                    newArray[index++] = listener;
                }
            } while (!ref.compareAndSet(oldArray, newArray));
            if (newArray.length != 0) break block4;
            this.listenerMap.remove(eventType);
        }
    }

    @Override
    public void post(@NotNull GrimEvent event) {
        Class<?> currentEventType = event.getClass();
        while (GrimEvent.class.isAssignableFrom(currentEventType)) {
            AtomicReference<OptimizedListener[]> ref = this.listenerMap.get(currentEventType);
            if (ref != null) {
                OptimizedListener[] listeners;
                for (OptimizedListener listener : listeners = ref.get()) {
                    try {
                        if (event.isCancelled() && !listener.ignoreCancelled) continue;
                        listener.listener.handle(event);
                    }
                    catch (Throwable throwable) {
                        System.err.println("Error handling event " + event.getEventName() + ": " + throwable.getMessage());
                        throwable.printStackTrace();
                    }
                }
            }
            currentEventType = currentEventType.getSuperclass();
        }
    }

    @Override
    public <T extends GrimEvent> void subscribe(GrimPlugin plugin, @NotNull Class<T> eventType, @NotNull GrimEventListener<T> listener, int priority, boolean ignoreCancelled, @NotNull Class<?> declaringClass) {
        OptimizedListener optimizedListener = new OptimizedListener(plugin, listener, priority, ignoreCancelled, declaringClass, null);
        this.addListener(eventType, optimizedListener);
    }

    private static class OptimizedListener {
        final GrimPlugin plugin;
        final GrimEventListener<GrimEvent> listener;
        final int priority;
        final boolean ignoreCancelled;
        final Class<?> declaringClass;
        final Object instance;

        OptimizedListener(GrimPlugin plugin, GrimEventListener<GrimEvent> listener, int priority, boolean ignoreCancelled, Class<?> declaringClass, Object instance) {
            this.plugin = plugin;
            this.listener = listener;
            this.priority = priority;
            this.ignoreCancelled = ignoreCancelled;
            this.declaringClass = declaringClass;
            this.instance = instance;
        }
    }
}

