/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.file;

import dev.amsam0.voicechatdiscord.shadow.snakeyaml.DumperOptions;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.LoaderOptions;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.Yaml;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.comments.CommentLine;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.comments.CommentType;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.constructor.BaseConstructor;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.error.YAMLException;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.nodes.AnchorNode;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.nodes.MappingNode;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.nodes.Node;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.nodes.NodeTuple;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.nodes.ScalarNode;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.nodes.SequenceNode;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.nodes.Tag;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.reader.UnicodeReader;
import dev.amsam0.voicechatdiscord.shadow.snakeyaml.representer.Representer;
import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.configuration.Configuration;
import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.configuration.ConfigurationSection;
import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.configuration.InvalidConfigurationException;
import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.file.FileConfiguration;
import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.file.YamlConfigurationOptions;
import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.file.YamlConstructor;
import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.file.YamlRepresenter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public final class YamlConfiguration
extends FileConfiguration {
    private final YamlConstructor yamlConstructor;
    private final YamlRepresenter yamlRepresenter;
    private final DumperOptions dumperOptions = new DumperOptions();
    private final LoaderOptions loaderOptions;
    private final Yaml yaml;

    public YamlConfiguration() {
        this.dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.loaderOptions = new LoaderOptions();
        this.yamlConstructor = new YamlConstructor(this.loaderOptions);
        this.yamlRepresenter = new YamlRepresenter(this.dumperOptions);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml((BaseConstructor)this.yamlConstructor, (Representer)this.yamlRepresenter, this.dumperOptions, this.loaderOptions);
    }

    public YamlConfiguration(@Nullable Configuration defs) {
        super(defs);
        this.dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.loaderOptions = new LoaderOptions();
        this.yamlConstructor = new YamlConstructor(this.loaderOptions);
        this.yamlRepresenter = new YamlRepresenter(this.dumperOptions);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml((BaseConstructor)this.yamlConstructor, (Representer)this.yamlRepresenter, this.dumperOptions, this.loaderOptions);
    }

    @Override
    @NotNull
    public String saveToString() {
        this.dumperOptions.setIndent(this.getOptions().getIndent());
        this.dumperOptions.setWidth(this.getOptions().getWidth());
        this.dumperOptions.setProcessComments(this.getOptions().getParseComments());
        MappingNode mappingNode = this.toNodeTree(this);
        mappingNode.setBlockComments(this.getCommentLines(this.saveHeader(this.getOptions().getHeader()), CommentType.BLOCK));
        mappingNode.setEndComments(this.getCommentLines(this.getOptions().getFooter(), CommentType.BLOCK));
        StringWriter writer = new StringWriter();
        if (mappingNode.getBlockComments().isEmpty() && mappingNode.getEndComments().isEmpty() && mappingNode.getValue().isEmpty()) {
            writer.write("");
        } else {
            if (mappingNode.getValue().isEmpty()) {
                mappingNode.setFlowStyle(DumperOptions.FlowStyle.FLOW);
            }
            this.yaml.serialize(mappingNode, writer);
        }
        return writer.toString();
    }

    @NotNull
    private MappingNode toNodeTree(@NotNull ConfigurationSection section) {
        ArrayList<NodeTuple> nodeTuples = new ArrayList<NodeTuple>();
        for (Map.Entry<String, Object> entry : section.getValues(false).entrySet()) {
            Node keyNode = this.yamlRepresenter.represent(entry.getKey());
            Node valueNode = entry.getValue() instanceof ConfigurationSection ? this.toNodeTree((ConfigurationSection)entry.getValue()) : this.yamlRepresenter.represent(entry.getValue());
            keyNode.setBlockComments(this.getCommentLines(section.getComments(entry.getKey()), CommentType.BLOCK));
            if (valueNode instanceof MappingNode || valueNode instanceof SequenceNode) {
                keyNode.setInLineComments(this.getCommentLines(section.getInlineComments(entry.getKey()), CommentType.IN_LINE));
            } else {
                valueNode.setInLineComments(this.getCommentLines(section.getInlineComments(entry.getKey()), CommentType.IN_LINE));
            }
            nodeTuples.add(new NodeTuple(keyNode, valueNode));
        }
        return new MappingNode(Tag.MAP, nodeTuples, DumperOptions.FlowStyle.BLOCK);
    }

    @NotNull
    private List<CommentLine> getCommentLines(@NotNull List<String> comments, @NotNull CommentType commentType) {
        ArrayList<CommentLine> commentLines = new ArrayList<CommentLine>();
        for (String comment : comments) {
            if (comment == null) {
                commentLines.add(new CommentLine(null, null, "", CommentType.BLANK_LINE));
                continue;
            }
            String line = comment;
            line = line.isEmpty() ? line : " " + line;
            commentLines.add(new CommentLine(null, null, line, commentType));
        }
        return commentLines;
    }

    @NotNull
    private List<String> saveHeader(@NotNull List<String> header) {
        LinkedList<String> formattedHeader = new LinkedList<String>(header);
        if (!formattedHeader.isEmpty()) {
            formattedHeader.add(null);
        }
        return formattedHeader;
    }

    @Override
    public void loadFromString(@NotNull String data) throws InvalidConfigurationException {
        MappingNode mappingNode;
        this.loaderOptions.setMaxAliasesForCollections(this.getOptions().getMaxAliases());
        this.loaderOptions.setCodePointLimit(this.getOptions().getCodePointLimit());
        this.loaderOptions.setProcessComments(this.getOptions().getParseComments());
        try (UnicodeReader reader = new UnicodeReader(new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)));){
            Node rawNode = this.yaml.compose(reader);
            try {
                mappingNode = (MappingNode)rawNode;
            }
            catch (ClassCastException e) {
                throw new InvalidConfigurationException("Top level is not a Map.", e);
            }
        }
        catch (YAMLException | IOException | ClassCastException e) {
            throw new InvalidConfigurationException(e);
        }
        this.clear();
        if (mappingNode != null) {
            this.adjustNodeComments(mappingNode);
            this.getOptions().setHeader((List)this.loadHeader(this.getCommentLines(mappingNode.getBlockComments())));
            this.getOptions().setFooter((List)this.getCommentLines(mappingNode.getEndComments()));
            this.fromNodeTree(mappingNode, this);
        }
    }

    private void adjustNodeComments(@NotNull MappingNode mappingNode) {
        Node node;
        List<CommentLine> comments;
        if (mappingNode.getBlockComments() == null && !mappingNode.getValue().isEmpty() && (comments = (node = mappingNode.getValue().get(0).getKeyNode()).getBlockComments()) != null) {
            int commentIndex = -1;
            for (int index = 0; index < comments.size(); ++index) {
                if (comments.get(index).getCommentType() != CommentType.BLANK_LINE) continue;
                commentIndex = index;
            }
            if (commentIndex != -1) {
                mappingNode.setBlockComments(comments.subList(0, commentIndex + 1));
                node.setBlockComments(comments.subList(commentIndex + 1, comments.size()));
            }
        }
    }

    @NotNull
    private List<String> getCommentLines(@Nullable List<CommentLine> commentLines) {
        ArrayList<String> comments = new ArrayList<String>();
        if (commentLines == null) {
            return comments;
        }
        for (CommentLine commentLine : commentLines) {
            if (commentLine.getCommentType() == CommentType.BLANK_LINE) {
                comments.add(null);
                continue;
            }
            String comment = commentLine.getValue();
            comment = comment.startsWith(" ") ? comment.substring(1) : comment;
            comments.add(comment);
        }
        return comments;
    }

    @NotNull
    private List<String> loadHeader(@NotNull List<String> formattedHeader) {
        LinkedList<String> header = new LinkedList<String>(formattedHeader);
        if (!header.isEmpty()) {
            header.removeLast();
        }
        while (!header.isEmpty() && header.peek() == null) {
            header.remove();
        }
        return header;
    }

    private void fromNodeTree(@NotNull MappingNode mappingNode, @NotNull ConfigurationSection section) {
        this.yamlConstructor.flattenMapping(mappingNode);
        for (NodeTuple nodeTuple : mappingNode.getValue()) {
            Node keyNode = nodeTuple.getKeyNode();
            String key = String.valueOf(this.yamlConstructor.construct(keyNode));
            Node valueNode = nodeTuple.getValueNode();
            while (valueNode instanceof AnchorNode) {
                valueNode = ((AnchorNode)valueNode).getRealNode();
            }
            if (valueNode instanceof MappingNode && !this.hasSerializedTypeKey((MappingNode)valueNode)) {
                this.fromNodeTree((MappingNode)valueNode, section.createSection(key));
            } else {
                section.set(key, this.yamlConstructor.construct(valueNode));
            }
            section.setComments(key, this.getCommentLines(keyNode.getBlockComments()));
            if (valueNode instanceof MappingNode || valueNode instanceof SequenceNode) {
                section.setInlineComments(key, this.getCommentLines(keyNode.getInLineComments()));
                continue;
            }
            section.setInlineComments(key, this.getCommentLines(valueNode.getInLineComments()));
        }
    }

    private boolean hasSerializedTypeKey(@NotNull MappingNode mappingNode) {
        for (NodeTuple nodeTuple : mappingNode.getValue()) {
            String key;
            Node keyNode = nodeTuple.getKeyNode();
            if (!(keyNode instanceof ScalarNode) || !(key = ((ScalarNode)keyNode).getValue()).equals("==")) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public YamlConfigurationOptions getOptions() {
        if (this.options == null) {
            this.options = new YamlConfigurationOptions(this);
        }
        return (YamlConfigurationOptions)this.options;
    }

    @NotNull
    public static YamlConfiguration loadConfiguration(@NotNull File file) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (InvalidConfigurationException | IOException e) {
            LoggerFactory.getLogger(YamlConfiguration.class).error("Cannot load config from file: " + file.getPath(), (Throwable)e);
        }
        return config;
    }

    @NotNull
    public static YamlConfiguration loadConfiguration(@NotNull Reader reader) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(reader);
        }
        catch (InvalidConfigurationException | IOException e) {
            LoggerFactory.getLogger(YamlConfiguration.class).error("Cannot load config from reader.", (Throwable)e);
        }
        return config;
    }
}

