/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.Player;
import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import dev.amsam0.voicechatdiscord.Component;
import dev.amsam0.voicechatdiscord.Core;
import dev.amsam0.voicechatdiscord.DiscordBot;
import dev.amsam0.voicechatdiscord.GroupManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public final class SubCommands {
    @Nullable
    private static <V> V getArgumentOr(CommandContext<?> context, String name, Class<V> clazz, @Nullable V or) {
        try {
            return (V)context.getArgument(name, clazz);
        }
        catch (IllegalArgumentException ignored) {
            return or;
        }
    }

    public static <S> LiteralArgumentBuilder<S> build(LiteralArgumentBuilder<S> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(LiteralArgumentBuilder.literal((String)"start").executes(SubCommands.wrapInTry(SubCommands::start)))).then(LiteralArgumentBuilder.literal((String)"stop").executes(SubCommands.wrapInTry(SubCommands::stop)))).then(LiteralArgumentBuilder.literal((String)"reloadconfig").executes(SubCommands.wrapInTry(SubCommands::reloadConfig)))).then(LiteralArgumentBuilder.literal((String)"togglewhisper").executes(SubCommands.wrapInTry(SubCommands::toggleWhisper)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"group").executes(GroupCommands::help)).then(LiteralArgumentBuilder.literal((String)"list").executes(SubCommands.wrapInTry(GroupCommands::list)))).then(LiteralArgumentBuilder.literal((String)"create").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(SubCommands.wrapInTry(GroupCommands.create(Group.Type.NORMAL)))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"password", (ArgumentType)StringArgumentType.string()).executes(SubCommands.wrapInTry(GroupCommands.create(Group.Type.NORMAL)))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"normal").executes(SubCommands.wrapInTry(GroupCommands.create(Group.Type.NORMAL)))).then(RequiredArgumentBuilder.argument((String)"persistent", (ArgumentType)BoolArgumentType.bool()).executes(SubCommands.wrapInTry(GroupCommands.create(Group.Type.NORMAL)))))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"open").executes(SubCommands.wrapInTry(GroupCommands.create(Group.Type.OPEN)))).then(RequiredArgumentBuilder.argument((String)"persistent", (ArgumentType)BoolArgumentType.bool()).executes(SubCommands.wrapInTry(GroupCommands.create(Group.Type.OPEN)))))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"isolated").executes(SubCommands.wrapInTry(GroupCommands.create(Group.Type.ISOLATED)))).then(RequiredArgumentBuilder.argument((String)"persistent", (ArgumentType)BoolArgumentType.bool()).executes(SubCommands.wrapInTry(GroupCommands.create(Group.Type.ISOLATED))))))))).then(LiteralArgumentBuilder.literal((String)"join").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(SubCommands.wrapInTry(GroupCommands::join))).then(RequiredArgumentBuilder.argument((String)"password", (ArgumentType)StringArgumentType.string()).executes(SubCommands.wrapInTry(GroupCommands::join)))))).then(LiteralArgumentBuilder.literal((String)"info").executes(SubCommands.wrapInTry(GroupCommands::info)))).then(LiteralArgumentBuilder.literal((String)"leave").executes(SubCommands.wrapInTry(GroupCommands::leave)))).then(LiteralArgumentBuilder.literal((String)"remove").then(RequiredArgumentBuilder.argument((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(SubCommands.wrapInTry(GroupCommands::remove)))));
    }

    private static <S> Command<S> wrapInTry(Consumer<CommandContext<?>> function) {
        return sender -> {
            try {
                function.accept(sender);
            }
            catch (Throwable e) {
                Core.platform.error("An error occurred when running a command", e);
                Core.platform.sendMessage(sender, Component.red("An error occurred when running the command. Please check the console or tell your server owner to check the console."));
            }
            return 1;
        };
    }

    private static void start(CommandContext<?> sender) {
        if (!Core.platform.isValidPlayer(sender)) {
            Core.platform.sendMessage(sender, Component.red("You must be a player to use this command!"));
            return;
        }
        ServerPlayer player = Core.platform.commandContextToPlayer(sender);
        DiscordBot bot = Core.getBotForPlayer(player.getUuid(), true);
        DiscordBot botForPlayer = Core.getBotForPlayer(player.getUuid());
        if (botForPlayer != null) {
            if (!botForPlayer.isStarted()) {
                Core.platform.sendMessage(sender, Component.yellow("Your voice chat is currently starting."));
            } else {
                Core.platform.sendMessage(sender, Component.red("You have already started a voice chat! "), Component.yellow("Restarting your session..."));
                new Thread(() -> {
                    botForPlayer.stop();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    botForPlayer.logInAndStart(player);
                }, "voicechat-discord: Bot Restart for " + String.valueOf(player.getUuid())).start();
            }
            return;
        }
        if (bot == null) {
            Core.platform.sendMessage(sender, Component.red("There are currently no bots available. You might want to contact your server owner to add more."));
            return;
        }
        Core.platform.sendMessage(sender, Component.yellow("Starting a voice chat..."));
        new Thread(() -> bot.logInAndStart(player), "voicechat-discord: Bot Start for " + String.valueOf(player.getUuid())).start();
    }

    private static void stop(CommandContext<?> sender) {
        if (!Core.platform.isValidPlayer(sender)) {
            Core.platform.sendMessage(sender, Component.red("You must be a player to use this command!"));
            return;
        }
        ServerPlayer player = Core.platform.commandContextToPlayer(sender);
        DiscordBot bot = Core.getBotForPlayer(player.getUuid());
        if (bot == null || !bot.isStarted()) {
            Core.platform.sendMessage((Player)player, Component.red("You must start a voice chat before you can use this command!"));
            return;
        }
        Core.platform.sendMessage((Player)player, Component.yellow("Stopping the bot..."));
        new Thread(() -> {
            bot.stop();
            Core.platform.sendMessage(sender, Component.green("Successfully stopped the bot!"));
        }, "voicechat-discord: Bot Stop for " + String.valueOf(player.getUuid())).start();
    }

    private static void reloadConfig(CommandContext<?> sender) {
        if (!Core.platform.isOperator(sender) && !Core.platform.hasPermission(sender, "voicechat-discord.reload-config")) {
            Core.platform.sendMessage(sender, Component.red("You must be an operator or have the `voicechat-discord.reload-config` permission to use this command!"));
            return;
        }
        Core.platform.sendMessage(sender, Component.yellow("Stopping bots..."));
        new Thread(() -> {
            for (DiscordBot bot : Core.bots) {
                if (bot.player() == null) continue;
                Core.platform.sendMessage((Player)bot.player(), Component.red("The config is being reloaded which stops all bots. Please use "), Component.white("/dvc start"), Component.red(" to restart your session."));
            }
            Core.clearBots();
            Core.platform.sendMessage(sender, Component.green("Successfully stopped bots! "), Component.yellow("Reloading config..."));
            Core.loadConfig();
            Core.platform.sendMessage(sender, Component.green("Successfully reloaded config! Using " + Core.bots.size() + " bot" + (Core.bots.size() != 1 ? "s" : "") + "."));
        }, "voicechat-discord: Reload Config").start();
    }

    private static void toggleWhisper(CommandContext<?> sender) {
        if (!Core.platform.isValidPlayer(sender)) {
            Core.platform.sendMessage(sender, Component.red("You must be a player to use this command!"));
            return;
        }
        ServerPlayer player = Core.platform.commandContextToPlayer(sender);
        DiscordBot bot = Core.getBotForPlayer(player.getUuid());
        if (bot == null || !bot.isStarted()) {
            Core.platform.sendMessage((Player)player, Component.red("You must start a voice chat before you can use this command!"));
            return;
        }
        boolean set = !bot.whispering();
        bot.whispering(set);
        Core.platform.sendMessage(sender, set ? Component.green("Started whispering!") : Component.green("Stopped whispering!"));
    }

    private static final class GroupCommands {
        private GroupCommands() {
        }

        private static boolean checkIfGroupsEnabled(CommandContext<?> sender) {
            if (!Core.api.getServerConfig().getBoolean("enable_groups", true)) {
                Core.platform.sendMessage(sender, Component.red("Groups are currently disabled."));
                return true;
            }
            return false;
        }

        private static int help(CommandContext<?> sender) {
            Core.platform.sendMessage(sender, Component.red("Available subcommands:\n"), Component.red("- `"), Component.white("/dvc group list"), Component.red("`: List groups\n"), Component.red("- `"), Component.white("/dvc group create <name> [password] [type] [persistent]"), Component.red("`: Create a group\n"), Component.red("- `"), Component.white("/dvc group join <ID>"), Component.red("`: Join a group\n"), Component.red("- `"), Component.white("/dvc group info"), Component.red("`: Get info about your current group\n"), Component.red("- `"), Component.white("/dvc group leave"), Component.red("`: Leave your current group\n"), Component.red("- `"), Component.white("/dvc group remove <ID>"), Component.red("`: Removes a persistent group if there is no one in it\n"), Component.red("See "), Component.white("https://gitlab.com/amsam0/voicechat-discord#dvc-group"), Component.red(" for more info on how to use these commands."));
            return 1;
        }

        private static void list(CommandContext<?> sender) {
            if (GroupCommands.checkIfGroupsEnabled(sender)) {
                return;
            }
            Collection apiGroups = Core.api.getGroups();
            if (apiGroups.isEmpty()) {
                Core.platform.sendMessage(sender, Component.red("There are currently no groups."));
            } else {
                ArrayList<Component> groupsMessage = new ArrayList<Component>();
                groupsMessage.add(Component.green("Groups:"));
                for (Group group : apiGroups) {
                    groupsMessage.add(Component.white("\n"));
                    int friendlyId = (Integer)GroupManager.groupFriendlyIds.get(group.getId());
                    Core.platform.debugVerbose("Friendly ID for " + String.valueOf(group.getId()) + " (" + group.getName() + ") is " + friendlyId);
                    groupsMessage.add(Component.green(" - " + group.getName() + " (ID is " + friendlyId + "): "));
                    if (group.isPersistent()) {
                        groupsMessage.add(group.hasPassword() ? Component.red("Has password") : Component.green("No password"));
                        groupsMessage.add(Component.yellow(", persistent."));
                    } else {
                        groupsMessage.add(group.hasPassword() ? Component.red("Has password.") : Component.green("No password."));
                    }
                    String groupType = group.getType() == Group.Type.NORMAL ? "normal" : (group.getType() == Group.Type.OPEN ? "open" : (group.getType() == Group.Type.ISOLATED ? "isolated" : "unknown"));
                    groupsMessage.add(Component.green(" Group type is " + groupType + ". Players: "));
                    Component playersMessage = Component.red("No players");
                    List<ServerPlayer> players = GroupManager.groupPlayers.get(group.getId());
                    if (players == null) {
                        playersMessage = Component.red("Unable to get players");
                    } else if (!players.isEmpty()) {
                        playersMessage = Component.green(players.stream().map(player -> Core.platform.getName((Player)player)).collect(Collectors.joining(", ")));
                    }
                    groupsMessage.add(playersMessage);
                }
                Core.platform.sendMessage(sender, (Component[])groupsMessage.toArray(Component[]::new));
            }
        }

        private static Consumer<CommandContext<?>> create(Group.Type type) {
            return sender -> {
                if (!Core.platform.isValidPlayer((CommandContext<?>)sender)) {
                    Core.platform.sendMessage((CommandContext<?>)sender, Component.red("You must be a player to use this command!"));
                    return;
                }
                if (GroupCommands.checkIfGroupsEnabled(sender)) {
                    return;
                }
                String name = (String)sender.getArgument("name", String.class);
                String password = SubCommands.getArgumentOr(sender, "password", String.class, null);
                if (password != null && password.trim().isEmpty()) {
                    password = null;
                }
                Boolean persistent = SubCommands.getArgumentOr(sender, "persistent", Boolean.class, false);
                assert (persistent != null);
                VoicechatConnection connection = Objects.requireNonNull(Core.api.getConnectionOf(Core.platform.commandContextToPlayer((CommandContext<?>)sender)));
                if (connection.getGroup() != null) {
                    Core.platform.sendMessage((CommandContext<?>)sender, Component.red("You are already in a group!"));
                    return;
                }
                Group group = Core.api.groupBuilder().setName(name).setPassword(password).setType(type).setPersistent(persistent.booleanValue()).build();
                connection.setGroup(group);
                Core.platform.sendMessage((CommandContext<?>)sender, Component.green("Successfully created the group!"));
            };
        }

        private static void join(CommandContext<?> sender) {
            VoicechatConnection connection;
            if (!Core.platform.isValidPlayer(sender)) {
                Core.platform.sendMessage(sender, Component.red("You must be a player to use this command!"));
                return;
            }
            if (GroupCommands.checkIfGroupsEnabled(sender)) {
                return;
            }
            Integer friendlyId = (Integer)sender.getArgument("id", Integer.class);
            UUID groupId = GroupManager.groupFriendlyIds.getKey(friendlyId);
            if (groupId == null) {
                Core.platform.sendMessage(sender, Component.red("Invalid group ID. Please use "), Component.white("/dvc group list"), Component.red(" to see all groups."));
                return;
            }
            Group group = Objects.requireNonNull(Core.api.getGroup(groupId));
            if (group.hasPassword()) {
                String inputPassword = SubCommands.getArgumentOr(sender, "password", String.class, null);
                if (inputPassword != null && inputPassword.trim().isEmpty()) {
                    inputPassword = null;
                }
                if (inputPassword == null) {
                    Core.platform.sendMessage(sender, Component.red("The group has a password, and you have not provided one. Please rerun the command, including the password."));
                    return;
                }
                String groupPassword = GroupManager.getPassword(group);
                if (groupPassword == null) {
                    Core.platform.sendMessage(sender, Component.red("Since the group has a password, we need to check if the password you supplied is correct. However, we failed to get the password for the group (the server owner can see the error in console). You may need to update Simple Voice Chat Discord Bridge."));
                    return;
                }
                if (!inputPassword.equals(groupPassword)) {
                    Core.platform.sendMessage(sender, Component.red("The password you provided is incorrect. You may want to surround the password in quotes if the password has spaces in it."));
                    return;
                }
            }
            if ((connection = Objects.requireNonNull(Core.api.getConnectionOf(Core.platform.commandContextToPlayer(sender)))).getGroup() != null) {
                Core.platform.sendMessage(sender, Component.red("You are already in a group! Leave it using "), Component.white("/dvc group leave"), Component.red(", then join this group."));
                return;
            }
            DiscordBot botForPlayer = Core.getBotForPlayer(Core.platform.commandContextToPlayer(sender).getUuid());
            if (!(connection.isInstalled() || botForPlayer != null && botForPlayer.isStarted())) {
                Core.platform.sendMessage(sender, Component.red("You must have the Simple Voice Chat mod installed on your client or use "), Component.white("/dvc start"), Component.red(" before you can use this command!"));
                return;
            }
            connection.setGroup(group);
            Core.platform.sendMessage(sender, Component.green("Successfully joined group \"" + group.getName() + "\". Use "), Component.white("/dvc group info"), Component.green(" to see info on the group, and "), Component.white("/dvc group leave"), Component.green(" to leave the group."));
        }

        private static void info(CommandContext<?> sender) {
            if (!Core.platform.isValidPlayer(sender)) {
                Core.platform.sendMessage(sender, Component.red("You must be a player to use this command!"));
                return;
            }
            if (GroupCommands.checkIfGroupsEnabled(sender)) {
                return;
            }
            VoicechatConnection connection = Objects.requireNonNull(Core.api.getConnectionOf(Core.platform.commandContextToPlayer(sender)));
            Group group = connection.getGroup();
            if (group == null) {
                Core.platform.sendMessage(sender, Component.red("You are not in a group!"));
                return;
            }
            ArrayList<Component> components = new ArrayList<Component>();
            components.add(Component.green("You are currently in \"" + group.getName() + "\". It "));
            if (group.isPersistent()) {
                components.add(group.hasPassword() ? Component.red("has a password") : Component.green("does not have a password"));
                components.add(Component.yellow(" and is persistent."));
            } else {
                components.add(group.hasPassword() ? Component.red("has a password.") : Component.green("does not have a password."));
            }
            String groupType = group.getType() == Group.Type.NORMAL ? "normal" : (group.getType() == Group.Type.OPEN ? "open" : (group.getType() == Group.Type.ISOLATED ? "isolated" : "unknown"));
            components.add(Component.green(" Group type is " + groupType + ". Players: "));
            Component playersMessage = Component.red("No players");
            List<ServerPlayer> players = GroupManager.groupPlayers.get(group.getId());
            if (players == null) {
                playersMessage = Component.red("Unable to get players");
            } else if (!players.isEmpty()) {
                playersMessage = Component.green(players.stream().map(player -> Core.platform.getName((Player)player)).collect(Collectors.joining(", ")));
            }
            components.add(playersMessage);
            Core.platform.sendMessage(sender, (Component[])components.toArray(Component[]::new));
        }

        private static void leave(CommandContext<?> sender) {
            if (!Core.platform.isValidPlayer(sender)) {
                Core.platform.sendMessage(sender, Component.red("You must be a player to use this command!"));
                return;
            }
            if (GroupCommands.checkIfGroupsEnabled(sender)) {
                return;
            }
            VoicechatConnection connection = Objects.requireNonNull(Core.api.getConnectionOf(Core.platform.commandContextToPlayer(sender)));
            if (connection.getGroup() == null) {
                Core.platform.sendMessage(sender, Component.red("You are not in a group!"));
                return;
            }
            connection.setGroup(null);
            Core.platform.sendMessage(sender, Component.green("Successfully left the group."));
        }

        private static void remove(CommandContext<?> sender) {
            if (GroupCommands.checkIfGroupsEnabled(sender)) {
                return;
            }
            Integer friendlyId = (Integer)sender.getArgument("id", Integer.class);
            UUID groupId = GroupManager.groupFriendlyIds.getKey(friendlyId);
            if (groupId == null) {
                Core.platform.sendMessage(sender, Component.red("Invalid group ID. Please use "), Component.white("/dvc group list"), Component.red(" to see all groups."));
                return;
            }
            if (!Core.api.removeGroup(groupId)) {
                Core.platform.sendMessage(sender, Component.red("Couldn't remove the group. This means it either has players in it or it is not persistent."));
                return;
            }
            Core.platform.sendMessage(sender, Component.green("Successfully removed the group!"));
        }
    }
}

