/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord;

import de.maxhenkel.voicechat.api.VoicechatServerApi;
import dev.amsam0.voicechatdiscord.Constants;
import dev.amsam0.voicechatdiscord.DiscordBot;
import dev.amsam0.voicechatdiscord.LibraryLoader;
import dev.amsam0.voicechatdiscord.Platform;
import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.configuration.InvalidConfigurationException;
import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.file.YamlConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public final class Core {
    public static VoicechatServerApi api;
    public static Platform platform;
    public static ArrayList<DiscordBot> bots;
    public static int debugLevel;

    private static native void initializeNatives();

    private static native void setDebugLevel(int var0);

    private static native void shutdownNatives();

    public static void enable() {
        platform.info("Enabling voicechat-discord 3.1.2");
        try {
            LibraryLoader.load("voicechat_discord");
            Core.initializeNatives();
        }
        catch (Throwable e) {
            platform.error("Failed to load natives: " + String.valueOf(e));
            throw new RuntimeException(e);
        }
        Core.loadConfig();
        platform.setOnPlayerLeaveHandler(Core::onPlayerLeave);
        platform.info("Enabled voicechat-discord 3.1.2");
    }

    public static void disable() {
        platform.info("Disabling voicechat-discord 3.1.2");
        int toShutdown = bots.size();
        platform.info("Shutting down " + toShutdown + " bot" + (toShutdown != 1 ? "s" : ""));
        Core.clearBots();
        platform.info("Successfully shutdown " + toShutdown + " bot" + (toShutdown != 1 ? "s" : ""));
        try {
            Core.shutdownNatives();
            platform.info("Successfully shutdown native runtime");
        }
        catch (Throwable e) {
            platform.error("Failed to shutdown native runtime", e);
        }
        platform.info("Disabled voicechat-discord 3.1.2");
    }

    public static void loadConfig() {
        File configFile = new File(platform.getConfigPath());
        if (!configFile.getParentFile().exists()) {
            configFile.getParentFile().mkdirs();
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(configFile);
        }
        catch (IOException e) {
            platform.debug("IOException when loading config", e);
        }
        catch (InvalidConfigurationException e) {
            platform.error("Failed to load config file");
            throw new RuntimeException(e);
        }
        LinkedHashMap<String, String> defaultBot = new LinkedHashMap<String, String>();
        defaultBot.put("token", "DISCORD_BOT_TOKEN_HERE");
        defaultBot.put("vc_id", "VOICE_CHANNEL_ID_HERE");
        config.addDefault("bots", List.of(defaultBot));
        config.addDefault("alert_ops_of_updates", true);
        config.addDefault("debug_level", 0);
        config.getOptions().setCopyDefaults(true);
        config.getOptions().setHeader((List)Constants.CONFIG_HEADER);
        try {
            config.save(configFile);
        }
        catch (IOException e) {
            platform.error("Failed to save config file: " + String.valueOf(e));
            throw new RuntimeException(e);
        }
        bots.clear();
        for (LinkedHashMap bot : config.getList("bots")) {
            if (bot.get("token") == null) {
                platform.error("Failed to load a bot, missing token property.");
                continue;
            }
            if (bot.get("vc_id") == null) {
                platform.error("Failed to load a bot, missing vc_id property.");
                continue;
            }
            try {
                bots.add(new DiscordBot((String)bot.get("token"), (Long)bot.get("vc_id")));
            }
            catch (ClassCastException e) {
                platform.error("Failed to load a bot. Please make sure that the token property is a string and the vc_id property is a number.");
            }
        }
        platform.info("Using " + bots.size() + " bot" + (bots.size() != 1 ? "s" : ""));
        try {
            debugLevel = (Integer)config.get("debug_level");
            if (debugLevel > 0) {
                platform.info("Debug level has been set to " + debugLevel);
            }
            Core.setDebugLevel(debugLevel);
        }
        catch (ClassCastException e) {
            platform.error("Please make sure the debug_level option is a valid integer");
        }
    }

    public static void clearBots() {
        bots.forEach(discordBot -> {
            discordBot.stop();
            discordBot.free();
        });
        bots.clear();
    }

    private static void onPlayerLeave(UUID playerUuid) {
        DiscordBot bot = Core.getBotForPlayer(playerUuid);
        if (bot != null) {
            platform.info("Stopping bot for player " + String.valueOf(playerUuid));
            bot.stop();
        }
    }

    @Nullable
    public static DiscordBot getBotForPlayer(UUID playerUuid) {
        return Core.getBotForPlayer(playerUuid, false);
    }

    @Nullable
    public static DiscordBot getBotForPlayer(UUID playerUuid, boolean fallbackToAvailableBot) {
        for (DiscordBot bot : bots) {
            if (bot.player() == null || bot.player().getUuid() != playerUuid) continue;
            return bot;
        }
        if (fallbackToAvailableBot) {
            return Core.getAvailableBot();
        }
        return null;
    }

    @Nullable
    private static DiscordBot getAvailableBot() {
        for (DiscordBot bot : bots) {
            if (bot.player() != null) continue;
            return bot;
        }
        return null;
    }

    static {
        bots = new ArrayList();
        debugLevel = 0;
    }
}

