/*
 * Decompiled with CFR 0.152.
 */
package com.bobcat00.viaversionstatus.connections;

import com.bobcat00.viaversionstatus.connections.Connection;
import com.bobcat00.viaversionstatus.connections.ProtocolVersion;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.ViaAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ViaConnection
implements Connection {
    private boolean valid = Bukkit.getPluginManager().isPluginEnabled("ViaVersion");
    private ViaAPI api;

    public ViaConnection() {
        if (this.valid) {
            this.api = Via.getAPI();
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public ProtocolVersion getProtocol(Player player) {
        ProtocolVersion protocol = new ProtocolVersion();
        if (this.api != null) {
            protocol.id = this.api.getPlayerProtocolVersion((Object)player).getVersion();
            protocol.name = com.viaversion.viaversion.api.protocol.version.ProtocolVersion.getProtocol((int)protocol.id).getName();
        }
        return protocol;
    }

    @Override
    public ProtocolVersion getServerProtocol() {
        ProtocolVersion protocol = new ProtocolVersion();
        if (this.api != null) {
            protocol.id = this.api.getServerVersion().highestSupportedProtocolVersion().getVersion();
            protocol.name = com.viaversion.viaversion.api.protocol.version.ProtocolVersion.getProtocol((int)protocol.id).getName();
        }
        return protocol;
    }

    @Override
    public List<ProtocolVersion> getSupportedProtocols() {
        ArrayList<ProtocolVersion> versions = new ArrayList<ProtocolVersion>();
        if (this.api != null) {
            SortedSet protocols = this.api.getSupportedProtocolVersions();
            for (com.viaversion.viaversion.api.protocol.version.ProtocolVersion protocol : protocols) {
                versions.add(new ProtocolVersion(protocol.getVersion(), com.viaversion.viaversion.api.protocol.version.ProtocolVersion.getProtocol((int)protocol.getVersion()).getName()));
            }
        }
        return versions;
    }
}

