/*
 * Decompiled with CFR 0.152.
 */
package com.bobcat00.viaversionstatus;

import com.bobcat00.viaversionstatus.Config;
import com.bobcat00.viaversionstatus.Listeners;
import com.bobcat00.viaversionstatus.LogFilter;
import com.bobcat00.viaversionstatus.PrismEvent;
import com.bobcat00.viaversionstatus.PrismPlayerAction;
import com.bobcat00.viaversionstatus.bstats.bukkit.Metrics;
import com.bobcat00.viaversionstatus.bstats.charts.SimplePie;
import network.darkhelmet.prism.Prism;
import network.darkhelmet.prism.actionlibs.ActionTypeImpl;
import network.darkhelmet.prism.exceptions.InvalidActionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class ViaVersionStatus
extends JavaPlugin {
    ViaVersionStatus plugin = this;
    Config config;
    Listeners listeners;
    Prism prism;
    String prismVersion = "unknown";
    PrismEvent prismEvent;
    boolean prismHooked = false;
    boolean prismReady = false;
    int prismCounter = 0;

    public void onEnable() {
        this.config = new Config(this);
        this.saveDefaultConfig();
        this.config.updateConfig();
        this.listeners = new Listeners(this);
        if (this.config.getBlockNoLightDataWarnings()) {
            ((Logger)LogManager.getRootLogger()).addFilter((Filter)new LogFilter("No light data found for chunk"));
        }
        if (this.config.getPrismIntegration()) {
            Plugin prismPlugin = Bukkit.getPluginManager().getPlugin("Prism");
            if (prismPlugin != null && prismPlugin.isEnabled()) {
                try {
                    this.prism = (Prism)prismPlugin;
                    this.prismVersion = this.prism.getDescription().getVersion();
                    new BukkitRunnable(){

                        public void run() {
                            if (ViaVersionStatus.this.prismReady) {
                                try {
                                    ActionTypeImpl actionType = new ActionTypeImpl("vvs-client-connect", PrismPlayerAction.class, "client version");
                                    Prism.getActionRegistry().registerCustomAction((Plugin)ViaVersionStatus.this.plugin, actionType);
                                    ViaVersionStatus.this.prismEvent = new PrismEvent();
                                    ViaVersionStatus.this.prismHooked = true;
                                    ViaVersionStatus.this.getLogger().info("Hooked into Prism version " + ViaVersionStatus.this.prismVersion);
                                    this.cancel();
                                }
                                catch (InvalidActionException e) {
                                    ViaVersionStatus.this.getLogger().warning("Unable to hook into Prism: ");
                                    ViaVersionStatus.this.getLogger().warning(e.getMessage());
                                    ViaVersionStatus.this.getLogger().warning("Check Prism's config to ensure that tracking.api is true");
                                    ViaVersionStatus.this.getLogger().warning("and ViaVersionStatus is in the allowed-plugins list.");
                                    this.cancel();
                                }
                            } else {
                                if (ViaVersionStatus.this.prism.getPurgeManager() != null) {
                                    ViaVersionStatus.this.prismReady = true;
                                }
                                ++ViaVersionStatus.this.prismCounter;
                                if (ViaVersionStatus.this.prismCounter >= 50) {
                                    ViaVersionStatus.this.getLogger().warning("Unable to hook into Prism. Check if Prism is working.");
                                    this.cancel();
                                }
                            }
                        }
                    }.runTaskTimer((Plugin)this, 1L, 4L);
                }
                catch (NoClassDefFoundError e) {
                    this.getLogger().warning("Unable to hook into Prism. Make sure you are using Prism version 3.x or later.");
                }
            } else {
                this.getLogger().warning("prism-integration is true but Prism is not present or not enabled.");
            }
        }
        if (this.config.getEnableMetrics()) {
            int pluginId = 4834;
            Metrics metrics = new Metrics(this, pluginId);
            metrics.addCustomChart(new SimplePie("connection_used", () -> this.listeners.getConnectionUsed().toString()));
            metrics.addCustomChart(new SimplePie("viaversion", () -> Bukkit.getPluginManager().isPluginEnabled("ViaVersion") ? "Yes" : "No"));
            metrics.addCustomChart(new SimplePie("viabackwards", () -> Bukkit.getPluginManager().isPluginEnabled("ViaBackwards") ? "Yes" : "No"));
            metrics.addCustomChart(new SimplePie("viarewind", () -> Bukkit.getPluginManager().isPluginEnabled("ViaRewind") ? "Yes" : "No"));
            metrics.addCustomChart(new SimplePie("notify_ops", () -> this.config.getNotifyOps() && !this.config.getNotifyString().isEmpty() ? "Yes" : "No"));
            metrics.addCustomChart(new SimplePie("notify_command", () -> this.config.getNotifyOps() && !this.config.getNotifyCommand().isEmpty() ? "Yes" : "No"));
            metrics.addCustomChart(new SimplePie("warn_players", () -> this.config.getOlderVersionWarnPlayers() && !this.config.getOlderVersionWarnString().isEmpty() ? "Yes" : "No"));
            metrics.addCustomChart(new SimplePie("warn_command", () -> this.config.getOlderVersionWarnPlayers() && !this.config.getOlderVersionWarnCommand().isEmpty() ? "Yes" : "No"));
            metrics.addCustomChart(new SimplePie("warn_players_newer", () -> this.config.getNewerVersionWarnPlayers() && !this.config.getNewerVersionWarnString().isEmpty() ? "Yes" : "No"));
            metrics.addCustomChart(new SimplePie("warn_command_newer", () -> this.config.getNewerVersionWarnPlayers() && !this.config.getNewerVersionWarnCommand().isEmpty() ? "Yes" : "No"));
            metrics.addCustomChart(new SimplePie("listener_priority", () -> this.config.getHighPriority() ? "Monitor" : "Normal"));
            metrics.addCustomChart(new SimplePie("list_protocols", () -> this.config.getListSupportedProtocols() ? "Yes" : "No"));
            metrics.addCustomChart(new SimplePie("block_no_light", () -> this.config.getBlockNoLightDataWarnings() ? "Yes" : "No"));
            metrics.addCustomChart(new SimplePie("prism_integration", () -> this.config.getPrismIntegration() ? this.prismVersion : "No"));
            this.getLogger().info("Metrics enabled if allowed by plugins/bStats/config.yml");
        }
    }

    public void onDisable() {
    }

    public void shutdown() {
        this.setEnabled(false);
    }
}

