/*
 * Decompiled with CFR 0.152.
 */
package com.bobcat00.viaversionstatus;

import com.bobcat00.viaversionstatus.ViaVersionStatus;
import com.bobcat00.viaversionstatus.connections.ProtocolVersion;
import com.bobcat00.viaversionstatus.connections.ViaConnection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class Listeners
implements Listener {
    private ViaVersionStatus plugin;
    private ViaConnection via;
    private UseConnection useConnection = UseConnection.USE_NONE;
    private boolean outputVia = false;
    private int protocolListCounter = 0;

    public Listeners(final ViaVersionStatus plugin) {
        this.plugin = plugin;
        EventPriority priority = EventPriority.NORMAL;
        if (plugin.config.getHighPriority()) {
            priority = EventPriority.MONITOR;
            plugin.getLogger().info("Using listener priority " + priority.toString() + ".");
        }
        plugin.getServer().getPluginManager().registerEvent(PlayerJoinEvent.class, (Listener)this, priority, new EventExecutor(){

            public void execute(Listener l, Event e) {
                Listeners.this.onPlayerJoin((PlayerJoinEvent)e);
            }
        }, (Plugin)plugin);
        this.via = new ViaConnection();
        if (!this.via.isValid()) {
            plugin.getLogger().severe("This plugin requires ViaVersion.");
            plugin.shutdown();
            throw new RuntimeException("ViaVersion required.");
        }
        this.useConnection = UseConnection.USE_VIA;
        this.outputVia = true;
        if (plugin.config.getListSupportedProtocols()) {
            new BukkitRunnable(){

                public void run() {
                    List<ProtocolVersion> protocols;
                    if (Listeners.this.outputVia && (protocols = Listeners.this.via.getSupportedProtocols()) != null && !protocols.isEmpty()) {
                        plugin.getLogger().info("ViaVersion supported protocols:");
                        for (ProtocolVersion protocol : protocols) {
                            plugin.getLogger().info(protocol.toString());
                        }
                        Listeners.this.outputVia = false;
                    }
                    ++Listeners.this.protocolListCounter;
                    if (!Listeners.this.outputVia || Listeners.this.protocolListCounter >= 10) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)plugin, 100L, 100L);
        }
    }

    public UseConnection getConnectionUsed() {
        return this.useConnection;
    }

    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (player.hasPermission("viaversionstatus.exempt")) {
            return;
        }
        ProtocolVersion serverProtocol = null;
        ProtocolVersion clientProtocol = null;
        switch (this.useConnection) {
            case USE_VIA: {
                serverProtocol = this.via.getServerProtocol();
                clientProtocol = this.via.getProtocol(player);
                break;
            }
            case USE_NONE: {
                return;
            }
            default: {
                return;
            }
        }
        String clientVersion = clientProtocol.getName();
        String serverVersion = serverProtocol.getName();
        if (!player.hasPermission("viaversionstatus.exempt.log")) {
            this.plugin.getLogger().info(player.getName() + " is using version " + clientProtocol.toString() + ".");
        }
        if (this.plugin.config.getNotifyOps() && !player.hasPermission("viaversionstatus.exempt.notify")) {
            String notifyCommand;
            String notifyMessage;
            if (!player.hasPermission("viaversionstatus.exempt.notify.message") && !(notifyMessage = this.plugin.config.getNotifyString()).isEmpty()) {
                for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                    if (!p.hasPermission("viaversionstatus.notify") || p.hasPermission("viaversionstatus.notify.ignoresame") && clientProtocol.getId() == serverProtocol.getId()) continue;
                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)notifyMessage.replace("%player%", player.getName()).replace("%displayname%", player.getDisplayName()).replace("%version%", clientVersion).replace("%server%", serverVersion)));
                }
            }
            if (!player.hasPermission("viaversionstatus.exempt.notify.command") && !(notifyCommand = this.plugin.config.getNotifyCommand()).isEmpty()) {
                notifyCommand = notifyCommand.replace("%player%", player.getName()).replace("%displayname%", player.getDisplayName()).replace("%version%", clientVersion).replace("%server%", serverVersion);
                this.plugin.getLogger().info("Executing command " + notifyCommand);
                try {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), notifyCommand);
                }
                catch (CommandException exc) {
                    this.plugin.getLogger().warning("Command returned exception: " + exc.getMessage());
                }
            }
        }
        if (this.plugin.config.getOlderVersionWarnPlayers() && !serverVersion.equals("UNKNOWN") && clientProtocol.getId() < serverProtocol.getId() && !player.hasPermission("viaversionstatus.exempt.warn")) {
            this.handleMismatchedClientServerVersionsForTargetPlayer(player, "viaversionstatus.exempt.warn.message", "viaversionstatus.exempt.warn.command", this.plugin.config.getOlderVersionWarnString(), this.plugin.config.getOlderVersionWarnCommand(), clientVersion, serverVersion);
        }
        if (this.plugin.config.getNewerVersionWarnPlayers() && !serverVersion.equals("UNKNOWN") && clientProtocol.getId() > serverProtocol.getId() && !player.hasPermission("viaversionstatus.exempt.warn.newer")) {
            this.handleMismatchedClientServerVersionsForTargetPlayer(player, "viaversionstatus.exempt.warn.newer.message", "viaversionstatus.exempt.warn.newer.command", this.plugin.config.getNewerVersionWarnString(), this.plugin.config.getNewerVersionWarnCommand(), clientVersion, serverVersion);
        }
        if (this.plugin.prismHooked) {
            this.plugin.prismEvent.callPrismEvent((Plugin)this.plugin, "vvs-client-connect", player, clientProtocol.toString());
        }
    }

    private void handleMismatchedClientServerVersionsForTargetPlayer(final Player player, String messageExemptPermission, String commandExemptPermission, final String warnMessage, String warnCommand, final String clientVersion, final String serverVersion) {
        if (!player.hasPermission(messageExemptPermission) && !warnMessage.isEmpty()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (player.isOnline()) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)warnMessage.replace("%player%", player.getName()).replace("%displayname%", player.getDisplayName()).replace("%version%", clientVersion).replace("%server%", serverVersion)));
                    }
                }
            }, 5L);
        }
        if (!player.hasPermission(commandExemptPermission) && !warnCommand.isEmpty()) {
            warnCommand = warnCommand.replace("%player%", player.getName()).replace("%displayname%", player.getDisplayName()).replace("%version%", clientVersion).replace("%server%", serverVersion);
            this.plugin.getLogger().info("Executing command " + warnCommand);
            try {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), warnCommand);
            }
            catch (CommandException exc) {
                this.plugin.getLogger().warning("Command returned exception: " + exc.getMessage());
            }
        }
    }

    public static enum UseConnection {
        USE_VIA,
        USE_NONE;

    }
}

