/*
 * Decompiled with CFR 0.152.
 */
package com.bobcat00.viaversionstatus;

import com.bobcat00.viaversionstatus.ViaVersionStatus;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class Config {
    private ViaVersionStatus plugin;

    public Config(ViaVersionStatus plugin) {
        this.plugin = plugin;
    }

    public boolean getNotifyOps() {
        return this.plugin.getConfig().getBoolean("notify-ops");
    }

    public String getNotifyString() {
        return this.plugin.getConfig().getString("notify-string");
    }

    public String getNotifyCommand() {
        return this.plugin.getConfig().getString("notify-command");
    }

    public boolean getOlderVersionWarnPlayers() {
        return this.plugin.getConfig().getBoolean("warn-players");
    }

    public String getOlderVersionWarnString() {
        return this.plugin.getConfig().getString("warn-string");
    }

    public String getOlderVersionWarnCommand() {
        return this.plugin.getConfig().getString("warn-command");
    }

    public boolean getNewerVersionWarnPlayers() {
        return this.plugin.getConfig().getBoolean("warn-players-newer");
    }

    public String getNewerVersionWarnString() {
        return this.plugin.getConfig().getString("warn-string-newer");
    }

    public String getNewerVersionWarnCommand() {
        return this.plugin.getConfig().getString("warn-command-newer");
    }

    public boolean getHighPriority() {
        return this.plugin.getConfig().getBoolean("high-priority");
    }

    public boolean getListSupportedProtocols() {
        return this.plugin.getConfig().getBoolean("list-supported-protocols");
    }

    public boolean getBlockNoLightDataWarnings() {
        return this.plugin.getConfig().getBoolean("block-no-light-data-warnings");
    }

    public boolean getEnableMetrics() {
        return this.plugin.getConfig().getBoolean("enable-metrics");
    }

    public boolean getPrismIntegration() {
        return this.plugin.getConfig().getBoolean("prism-integration");
    }

    private boolean contains(String path, boolean ignoreDefault) {
        return (ignoreDefault ? this.plugin.getConfig().get(path, null) : this.plugin.getConfig().get(path)) != null;
    }

    public void updateConfig() {
        if (!this.contains("notify-ops", true)) {
            this.plugin.getConfig().set("notify-ops", (Object)true);
        }
        if (!this.contains("notify-command", true)) {
            this.plugin.getConfig().set("notify-command", (Object)"");
        }
        if (!this.contains("warn-command", true)) {
            this.plugin.getConfig().set("warn-command", (Object)"");
        }
        if (!this.contains("warn-players-newer", true)) {
            this.plugin.getConfig().set("warn-players-newer", (Object)this.plugin.getConfig().getBoolean("warn-players"));
        }
        if (!this.contains("warn-string-newer", true)) {
            this.plugin.getConfig().set("warn-string-newer", (Object)this.plugin.getConfig().getString("warn-string"));
        }
        if (!this.contains("warn-command-newer", true)) {
            this.plugin.getConfig().set("warn-command-newer", (Object)this.plugin.getConfig().getString("warn-command"));
        }
        if (!this.contains("list-supported-protocols", true)) {
            this.plugin.getConfig().set("list-supported-protocols", (Object)true);
        }
        if (!this.contains("block-no-light-data-warnings", true)) {
            this.plugin.getConfig().set("block-no-light-data-warnings", (Object)false);
        }
        if (!this.contains("enable-metrics", true)) {
            this.plugin.getConfig().set("enable-metrics", (Object)true);
        }
        if (!this.contains("prism-integration", true)) {
            this.plugin.getConfig().set("prism-integration", (Object)false);
        }
        this.saveConfig();
    }

    public void saveConfig() {
        try {
            File outFile = new File(this.plugin.getDataFolder(), "config.yml");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile.getAbsolutePath()), Charset.forName("UTF-8")));
            writer.write("# Strings should be enclosed in double quotes: \"...\"\n");
            writer.write("# Supported variables are %player%, %displayname%, %version%, and %server%\n");
            writer.write("# \\n can be used as a line break\n");
            writer.write("\n");
            writer.write("# Notify ops when a player joins\n");
            writer.write("notify-ops: " + this.plugin.getConfig().getBoolean("notify-ops") + "\n");
            writer.write("notify-string: \"" + this.plugin.getConfig().getString("notify-string").replaceAll("\n", "\\\\n") + "\"\n");
            writer.write("notify-command: \"" + this.plugin.getConfig().getString("notify-command") + "\"\n");
            writer.write("\n");
            writer.write("# Warn players when they are using an older version\n");
            writer.write("warn-players: " + this.plugin.getConfig().getBoolean("warn-players") + "\n");
            writer.write("warn-string: \"" + this.plugin.getConfig().getString("warn-string").replaceAll("\n", "\\\\n") + "\"\n");
            writer.write("warn-command: \"" + this.plugin.getConfig().getString("warn-command") + "\"\n");
            writer.write("\n");
            writer.write("# Warn players when they are using a newer version\n");
            writer.write("warn-players-newer: " + this.plugin.getConfig().getBoolean("warn-players-newer") + "\n");
            writer.write("warn-string-newer: \"" + this.plugin.getConfig().getString("warn-string-newer").replaceAll("\n", "\\\\n") + "\"\n");
            writer.write("warn-command-newer: \"" + this.plugin.getConfig().getString("warn-command-newer") + "\"\n");
            writer.write("\n");
            writer.write("# Run at the highest priority (MONITOR)\n");
            writer.write("# Set to true if %displayname% doesn't work as expected\n");
            writer.write("high-priority: " + this.plugin.getConfig().getBoolean("high-priority") + "\n");
            writer.write("\n");
            writer.write("# At startup, list the protocols supported by ViaVersion\n");
            writer.write("list-supported-protocols: " + this.plugin.getConfig().getBoolean("list-supported-protocols") + "\n");
            writer.write("\n");
            writer.write("# Block \"No light data found for chunk\" warning messages\n");
            writer.write("block-no-light-data-warnings: " + this.plugin.getConfig().getBoolean("block-no-light-data-warnings") + "\n");
            writer.write("\n");
            writer.write("# Enable metrics (subject to bStats global config)\n");
            writer.write("enable-metrics: " + this.plugin.getConfig().getBoolean("enable-metrics") + "\n");
            writer.write("\n");
            writer.write("# Record data via Prism, with the action vvs-client-connect\n");
            writer.write("prism-integration: " + this.plugin.getConfig().getBoolean("prism-integration") + "\n");
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.plugin.reloadConfig();
    }
}

