/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addon.terrascript.check;

import com.dfsek.terra.addon.terrascript.check.lib.jafama.FastMath;
import com.dfsek.terra.addons.chunkgenerator.generation.NoiseChunkGenerator3D;
import com.dfsek.terra.addons.chunkgenerator.generation.math.samplers.SamplerProvider;
import com.dfsek.terra.addons.terrascript.parser.lang.ImplementationArguments;
import com.dfsek.terra.addons.terrascript.parser.lang.Returnable;
import com.dfsek.terra.addons.terrascript.parser.lang.Scope;
import com.dfsek.terra.addons.terrascript.parser.lang.functions.Function;
import com.dfsek.terra.addons.terrascript.script.TerraImplementationArguments;
import com.dfsek.terra.addons.terrascript.tokenizer.Position;
import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.RotationUtil;
import com.dfsek.terra.api.util.vector.Vector2;
import com.dfsek.terra.api.util.vector.Vector3;
import com.dfsek.terra.api.world.World;
import com.dfsek.terra.api.world.WritableWorld;
import com.dfsek.terra.api.world.info.WorldProperties;

public class CheckFunction
implements Function<String> {
    private final Returnable<Number> x;
    private final Returnable<Number> y;
    private final Returnable<Number> z;
    private final Position position;

    public CheckFunction(Returnable<Number> x, Returnable<Number> y, Returnable<Number> z, Position position) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.position = position;
    }

    public String apply(ImplementationArguments implementationArguments, Scope scope) {
        TerraImplementationArguments arguments = (TerraImplementationArguments)implementationArguments;
        Vector2 xz = Vector2.of((double)((Number)this.x.apply(implementationArguments, scope)).doubleValue(), (double)((Number)this.z.apply(implementationArguments, scope)).doubleValue());
        RotationUtil.rotateVector((Vector2)xz, (Rotation)arguments.getRotation());
        Vector3 location = arguments.getOrigin().toVector3Mutable().add(Vector3.of((double)FastMath.roundToInt(xz.getX()), (double)((Number)this.y.apply(implementationArguments, scope)).doubleValue(), (double)FastMath.roundToInt(xz.getZ()))).immutable();
        return this.apply(location, arguments.getWorld());
    }

    public Position getPosition() {
        return this.position;
    }

    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.STRING;
    }

    private String apply(Vector3 vector, WritableWorld world) {
        int y = vector.getBlockY();
        if (y >= world.getMaxHeight() || y < 0) {
            return "AIR";
        }
        SamplerProvider cache = ((NoiseChunkGenerator3D)world.getGenerator()).samplerProvider();
        double comp = this.sample(vector.getX(), vector.getY(), vector.getZ(), cache, (World)world);
        if (comp > 0.0) {
            return "LAND";
        }
        return "AIR";
    }

    private double sample(double x, double y, double z, SamplerProvider cache, World world) {
        int cx = FastMath.floorDiv((int)x, 16);
        int cz = FastMath.floorDiv((int)z, 16);
        return cache.getChunk(cx, cz, (WorldProperties)world, world.getBiomeProvider()).sample(x - (double)(cx << 4), y, z - (double)(cz << 4));
    }
}

