/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.skript.elements;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import io.github.apickledwalrus.skriptplaceholders.SkriptPlaceholders;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderEvaluator;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderPlugin;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderRegistry;
import io.github.apickledwalrus.skriptplaceholders.skript.PlaceholderEvent;
import io.github.apickledwalrus.skriptplaceholders.skript.RelationalPlaceholderEvent;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.script.Script;
import org.skriptlang.skript.lang.structure.Structure;

@Name(value="Custom Placeholder")
@Description(value={"A structure for creating custom placeholders.", "The code will be executed every time the placeholder plugin requests a value for the placeholder."})
@Examples(value={"placeholderapi placeholder with the prefix \"skriptplaceholders\":", "\tif the identifier is \"author\": # Placeholder is \"%skriptplaceholders_author%\"", "\t\tset the result to \"APickledWalrus\"", "placeholderapi relational placeholder with the prefix \"skriptplaceholders\":", "\tif the identifier is \"longer_name\": # Placeholder is \"%rel_skriptplaceholders_longer_name%\"", "\t\tif the length of the name of the first player > the length of the name of the second player:", "\t\t\tset the result to the name of the first player", "\t\telse:", "\t\t\tset the result to the name of the second player", "mvdw placeholder named \"skriptplaceholders_author\":", "\t# Placeholder is \"{skriptplaceholders_author}\"", "\tset the result to \"APickledWalrus\""})
@Since(value="1.0.0, 1.3.0 (MVdWPlaceholderAPI support), 1.7.0 (relational placeholder support)")
public class StructCustomPlaceholder
extends Structure
implements PlaceholderEvaluator {
    private PlaceholderRegistry registry;
    private PlaceholderPlugin plugin;
    private String placeholder;
    private boolean isRelational;
    private Trigger trigger;

    public boolean init(Literal<?> @NotNull [] args, int matchedPattern, @NotNull SkriptParser.ParseResult parseResult, @NotNull EntryContainer entryContainer) {
        this.plugin = PlaceholderPlugin.values()[matchedPattern <= 1 ? matchedPattern : matchedPattern - 2];
        if (!this.plugin.isInstalled()) {
            Skript.error((String)(this.plugin.getDisplayName() + " placeholders can not be created because the plugin is not installed."));
            return false;
        }
        String placeholder = (String)args[0].getSingle();
        String error = this.plugin.validatePrefix(placeholder);
        if (error != null) {
            Skript.error((String)error);
            return false;
        }
        this.placeholder = placeholder;
        this.registry = SkriptPlaceholders.getInstance().getRegistry();
        this.isRelational = parseResult.hasTag("relational");
        return true;
    }

    public boolean load() {
        ParserInstance parser = this.getParser();
        Script script = parser.getCurrentScript();
        SectionNode source = this.getEntryContainer().getSource();
        parser.setCurrentEvent("custom placeholder", new Class[]{this.isRelational ? RelationalPlaceholderEvent.class : PlaceholderEvent.class});
        this.trigger = new Trigger(script, parser.getCurrentEventName(), (SkriptEvent)new SimpleEvent(), (List)ScriptLoader.loadItems((SectionNode)source));
        int lineNumber = source.getLine();
        this.trigger.setLineNumber(lineNumber);
        this.trigger.setDebugLabel(script + ": line " + lineNumber);
        if (Bukkit.isPrimaryThread()) {
            this.registry.registerPlaceholder(this.plugin, this.placeholder, this);
        } else {
            Bukkit.getScheduler().runTask((Plugin)SkriptPlaceholders.getInstance(), () -> this.registry.registerPlaceholder(this.plugin, this.placeholder, this));
        }
        return true;
    }

    public void unload() {
        if (Bukkit.isPrimaryThread()) {
            this.registry.unregisterPlaceholder(this.plugin, this.placeholder, this);
        } else {
            Bukkit.getScheduler().runTask((Plugin)SkriptPlaceholders.getInstance(), () -> this.registry.unregisterPlaceholder(this.plugin, this.placeholder, this));
        }
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        switch (this.plugin) {
            case PLACEHOLDER_API: {
                return "placeholderapi " + (this.isRelational ? "relational " : "") + "placeholder with the prefix " + this.placeholder;
            }
            case MVDW_PLACEHOLDER_API: {
                return "mvdwplaceholderapi placeholder named " + this.placeholder;
            }
        }
        throw new IllegalArgumentException("Unable to handle PlaceholderPlugin: " + (Object)((Object)this.plugin));
    }

    @Override
    @Nullable
    public String evaluate(String placeholder, @Nullable OfflinePlayer player) {
        if (this.isRelational) {
            return null;
        }
        PlaceholderEvent event = new PlaceholderEvent(placeholder, player);
        this.trigger.execute((Event)event);
        return event.getResult();
    }

    @Override
    @Nullable
    public String evaluateRelational(String placeholder, Player one, Player two) {
        if (!this.isRelational) {
            return null;
        }
        RelationalPlaceholderEvent event = new RelationalPlaceholderEvent(placeholder, one, two);
        this.trigger.execute((Event)event);
        return event.getResult();
    }

    static {
        Skript.registerStructure(StructCustomPlaceholder.class, (String[])new String[]{"(placeholder[ ]api|papi) [:relational] placeholder (with|for) [the] prefix %*string%", "(mvdw[ ]placeholder[ ]api|mvdw) placeholder [with [the] name|named] %*string%"});
        EventValues.registerEventValue(PlaceholderEvent.class, Player.class, (Getter)new Getter<Player, PlaceholderEvent>(){

            public Player get(PlaceholderEvent event) {
                OfflinePlayer player = event.getPlayer();
                return player != null ? player.getPlayer() : null;
            }
        }, (int)0);
        EventValues.registerEventValue(PlaceholderEvent.class, OfflinePlayer.class, (Getter)new Getter<OfflinePlayer, PlaceholderEvent>(){

            public OfflinePlayer get(PlaceholderEvent event) {
                return event.getPlayer();
            }
        }, (int)0);
    }
}

