/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.skript.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.skriptplaceholders.skript.RelationalPlaceholderEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Relational Placeholder Players")
@Description(value={"The two players involved in a relational placeholder request."})
@Examples(value={"placeholderapi relational placeholder with the prefix \"skriptplaceholders\":", "\tif the identifier is \"longer_name\": # Placeholder is \"%rel_skriptplaceholders_longer_name%\"", "\t\tif the length of the name of the first player > the length of the name of the second player:", "\t\t\tset the result to the name of the first player", "\t\telse:", "\t\t\tset the result to the name of the second player"})
@Since(value="1.7.0")
public class ExprRelationalPlaceholderPlayers
extends SimpleExpression<Player> {
    private boolean first;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean kleenean, @NotNull SkriptParser.ParseResult parseResult) {
        boolean bl = this.first = matchedPattern == 0;
        if (!this.getParser().isCurrentEvent(RelationalPlaceholderEvent.class)) {
            Skript.error((String)("'the " + (this.first ? "first" : "second") + " player' can only be used in custom relational placeholders."));
            return false;
        }
        return true;
    }

    protected Player @NotNull [] get(@NotNull Event e) {
        if (!(e instanceof RelationalPlaceholderEvent)) {
            return new Player[0];
        }
        RelationalPlaceholderEvent event = (RelationalPlaceholderEvent)e;
        return new Player[]{this.first ? event.getPlayer() : event.getOther()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Player> getReturnType() {
        return Player.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the " + (this.first ? "first" : "second") + " player";
    }

    static {
        Skript.registerExpression(ExprRelationalPlaceholderPlayers.class, Player.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] first player", "[the] second player"});
    }
}

