/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.skript.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderPlugin;
import java.util.ArrayList;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Placeholder Value")
@Description(value={"An expression to obtain the value of a placeholder from a supported plugin."})
@Examples(value={"command /ping <player>:", "\ttrigger:", "\t\tset {_ping} to the placeholder \"player_ping\" from arg-1 # PlaceholderAPI", "\t\tset {_ping} to the placeholder \"{ping}\" from arg-1 # MVdWPlaceholderAPI", "\t\tsend \"Ping of %arg-1%: %{_ping}%\" to the player", "command /friend status <player> <player>:", "\ttrigger:", "\tset {_status} to the relational placeholder \"rel_friendship_status\" from arg-1 and arg-2", "\tsend \"Status: %{_status}%\" to the player"})
@Since(value="1.0.0, 1.2.0 (MVdWPlaceholderAPI support), 1.7.0 (relational placeholder support)")
public class ExprPlaceholderValue
extends SimpleExpression<String> {
    private boolean isRelational;
    private Expression<String> placeholders;
    @Nullable
    private Expression<OfflinePlayer> players;

    public boolean init(Expression<?>[] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.isRelational = parseResult.hasTag("relational");
        this.placeholders = exprs[0];
        this.players = exprs[1];
        if (this.isRelational && (this.players == null || this.players.isSingle())) {
            Skript.error((String)"There must be two players provided to use relational placeholders.");
            return false;
        }
        return true;
    }

    protected String @NotNull [] get(@NotNull Event event) {
        OfflinePlayer[] offlinePlayerArray;
        String[] placeholders = (String[])this.placeholders.getArray(event);
        if (this.players != null) {
            offlinePlayerArray = (OfflinePlayer[])this.players.getArray(event);
        } else {
            OfflinePlayer[] offlinePlayerArray2 = new OfflinePlayer[1];
            offlinePlayerArray = offlinePlayerArray2;
            offlinePlayerArray2[0] = null;
        }
        OfflinePlayer[] players = offlinePlayerArray;
        if (this.isRelational) {
            if (players.length == 2) {
                Player one = players[0].getPlayer();
                Player two = players[1].getPlayer();
                if (one != null && two != null) {
                    return ExprPlaceholderValue.parseRelationalPlaceholders(placeholders, one, two);
                }
            }
            return new String[0];
        }
        return ExprPlaceholderValue.parsePlaceholders(placeholders, players);
    }

    private static String[] parsePlaceholders(String[] placeholders, @Nullable OfflinePlayer[] players) {
        ArrayList<String> values = new ArrayList<String>();
        for (OfflinePlayer player : players) {
            block1: for (String placeholder : placeholders) {
                for (PlaceholderPlugin plugin : PlaceholderPlugin.getInstalledPlugins()) {
                    String value = plugin.parsePlaceholder(placeholder, player);
                    if (value == null) continue;
                    values.add(value);
                    continue block1;
                }
            }
        }
        return values.toArray(new String[0]);
    }

    private static String[] parseRelationalPlaceholders(String[] placeholders, Player one, Player two) {
        ArrayList<String> values = new ArrayList<String>();
        block0: for (String placeholder : placeholders) {
            for (PlaceholderPlugin plugin : PlaceholderPlugin.getInstalledPlugins()) {
                String value;
                if (!plugin.supportsRelationalPlaceholders() || (value = plugin.parseRelationalPlaceholder(placeholder, one, two)) == null) continue;
                values.add(value);
                continue block0;
            }
        }
        return values.toArray(new String[0]);
    }

    public boolean isSingle() {
        return this.placeholders.isSingle() && (this.isRelational || this.players == null || this.players.isSingle());
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        StringBuilder string = new StringBuilder("the value of ");
        if (this.isRelational) {
            string.append("relational ");
        }
        string.append(this.placeholders.isSingle() ? "placeholder " : "placeholders ");
        string.append(this.placeholders.toString(event, debug));
        if (this.players != null) {
            string.append(" for ").append(this.players.toString(event, debug));
        }
        return string.toString();
    }

    static {
        Skript.registerExpression(ExprPlaceholderValue.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [value[s] of [the]] [:relational] placeholder[s] [in] %strings% [(for|from|of) %-players/offlineplayers%]", "[:relational] placeholder[s] %strings%'[s] value[s] [(for|from|of) %-players/offlineplayers%]"});
    }
}

