/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.skript.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import io.github.apickledwalrus.skriptplaceholders.skript.PlaceholderEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Placeholder Result")
@Description(value={"The value of a placeholder in a placeholder event. Can be set, reset, or deleted."})
@Examples(value={"placeholderapi placeholder with the prefix \"skriptplaceholders\":", "\tif the identifier is \"author\": # Placeholder is \"%skriptplaceholders_author%\"", "\t\tset the result to \"APickledWalrus\"", "mvdw placeholder named \"skriptplaceholders_author\":", "\t# Placeholder is \"{skriptplaceholders_author}\"", "\tset the result to \"APickledWalrus\""})
@Since(value="1.0.0, 1.3.0 (MVdWPlaceholderAPI support), 1.6.0 (using any type support)")
@Events(value={"Placeholder Request"})
public class ExprPlaceholderResult
extends SimpleExpression<String> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(PlaceholderEvent.class)) {
            Skript.error((String)"'the placeholder result' can only be used in custom placeholders");
            return false;
        }
        return true;
    }

    protected String @NotNull [] get(@NotNull Event event) {
        return new String[]{((PlaceholderEvent)event).getResult()};
    }

    public Class<?> @NotNull [] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case DELETE: 
            case RESET: {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
            }
        }
        return null;
    }

    public void change(@NotNull Event event, Object @NotNull [] delta, Changer.ChangeMode mode) {
        PlaceholderEvent placeholderEvent = (PlaceholderEvent)event;
        switch (mode) {
            case SET: {
                if (delta[0] instanceof String) {
                    placeholderEvent.setResult((String)delta[0]);
                    break;
                }
                placeholderEvent.setResult(Classes.toString((Object)delta[0]));
                break;
            }
            case DELETE: 
            case RESET: {
                placeholderEvent.setResult(null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the placeholder result";
    }

    static {
        Skript.registerExpression(ExprPlaceholderResult.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [placeholder] result"});
    }
}

