/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.skript.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.skriptplaceholders.skript.PlaceholderEvent;
import java.util.Locale;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Placeholder")
@Description(value={"An expression to obtain the placeholder (or part of it) in a placeholder request event."})
@Examples(value={"placeholderapi placeholder with the prefix \"skriptplaceholders\":", "\tbroadcast \"Placeholder: %the placeholder%\"", "\tbroadcast \"Prefix: %the placeholder prefix%\"", "\tbroadcast \"Identifier: %the placeholder identifier%\"", "mvdw placeholder named \"skriptplaceholders_test\":", "\tbroadcast \"Placeholder: %the placeholder%\""})
@Since(value="1.0.0, 1.3.0 (MVdWPlaceholderAPI support)")
@Events(value={"Placeholder Request"})
public class ExprPlaceholder
extends SimpleExpression<String> {
    private PlaceholderPart part;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.part = PlaceholderPart.values()[parseResult.mark];
        if (!this.getParser().isCurrentEvent(PlaceholderEvent.class)) {
            Skript.error((String)("'the " + this.part.name().toLowerCase(Locale.ENGLISH) + "' can only be used in custom placeholders"));
            return false;
        }
        return true;
    }

    protected String @NotNull [] get(@NotNull Event event) {
        if (!(event instanceof PlaceholderEvent)) {
            return new String[0];
        }
        PlaceholderEvent placeholderEvent = (PlaceholderEvent)event;
        switch (this.part) {
            case PLACEHOLDER: {
                return new String[]{placeholderEvent.getPlaceholder()};
            }
            case PREFIX: {
                String[] stringArray;
                String prefix = placeholderEvent.getPrefix();
                if (prefix != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = prefix;
                } else {
                    stringArray = new String[]{};
                }
                return stringArray;
            }
            case IDENTIFIER: {
                String[] stringArray;
                String identifier = placeholderEvent.getIdentifier();
                if (identifier != null) {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = identifier;
                } else {
                    stringArray = new String[]{};
                }
                return stringArray;
            }
        }
        throw new IllegalArgumentException("Unable to handle PlaceholderPart: " + (Object)((Object)this.part));
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        switch (this.part) {
            case PLACEHOLDER: {
                return "the placeholder";
            }
            case PREFIX: {
                return "the placeholder prefix";
            }
            case IDENTIFIER: {
                return "the placeholder identifier";
            }
        }
        throw new IllegalArgumentException("Unable to handle PlaceholderPart: " + (Object)((Object)this.part));
    }

    static {
        Skript.registerExpression(ExprPlaceholder.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] placeholder", "[the] [placeholder] (1:prefix|2:identifier)"});
    }

    private static enum PlaceholderPart {
        PLACEHOLDER,
        PREFIX,
        IDENTIFIER;

    }
}

